<?php
/***************************************************************************
 *                            viewpost_reports.php
 *                            --------------------
 *   begin                : Sunday, Jun 19, 2005
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: viewpost_reports.php,v 2.1.5.0 2005/10/28 14:18:00 chatasos Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/bbcode.'.$phpEx);
include($phpbb_root_path . 'includes/functions_post.'.$phpEx);
include($phpbb_root_path . 'includes/functions_report_global.'.$phpEx);
include($phpbb_root_path . 'includes/functions_report.'.$phpEx);
//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);
//
// End session management
//

//
// Language File
//
include($phpbb_root_path.'language/lang_'.$board_config['default_lang'].'/lang_report_posts.'.$phpEx);


// debug
/*
echo "POST:" ; print_r($HTTP_POST_VARS); echo "<br />";
echo "GET: " ; print_r($HTTP_GET_VARS); echo "<br />";
*/
// end of debug



if( !$userdata['session_logged_in'] )
{
	redirect($phpbb_root_path . 'login.' . $phpEx . '?redirect=viewpost_reports.' . $phpEx);
}

if ( $userdata['user_level'] < ADMIN )
{
	message_die(GENERAL_MESSAGE, $lang['Not_Moderator'], $lang['Not_Authorised']);
}

$reports_config = get_reports_config();

$action_submitted = ( isset($HTTP_POST_VARS['submit_action']) ) ? true : false;
$display_submitted = ( isset($HTTP_POST_VARS['submit_display']) ) ? true : false;
$submit = ( isset($HTTP_POST_VARS['submit']) ) ? true : false;

$start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;

if ( isset($HTTP_POST_VARS['status']) || isset($HTTP_GET_VARS['status']) )
{
	$status = ( !empty($HTTP_POST_VARS['status']) ) ? intval($HTTP_POST_VARS['status']) : intval($HTTP_GET_VARS['status']);
}
else
{
	$status = intval($reports_config['default_reports_status']);
}

// we accept POST 'mode' only when it has been done through its own submit button
if ( ( isset($HTTP_POST_VARS['mode']) && $action_submitted ) || isset($HTTP_GET_VARS['mode']) )
{
	$mode = ( !empty($HTTP_POST_VARS['mode']) ) ? htmlspecialchars($HTTP_POST_VARS['mode']) : htmlspecialchars($HTTP_GET_VARS['mode']);
}
else
{
	$mode = '';
}

// get the report_id
if ( isset($HTTP_POST_VARS['report']) || isset($HTTP_GET_VARS['report']) )
{
	$report_id = ( !empty($HTTP_POST_VARS['report']) ) ? intval($HTTP_POST_VARS['report']) : intval($HTTP_GET_VARS['report']);
}
else
{
	$report_id = '';
}

// get all the report ids
if ( isset($HTTP_POST_VARS[POST_POST_URL]) && !empty($HTTP_POST_VARS[POST_POST_URL]) )
{
	$report_ids = array();
	foreach($HTTP_POST_VARS[POST_POST_URL] as $row)
	{
		$report_ids[] = intval($row);
	}

	// use only the 1st array entry in the var
	$report_id = $report_ids[0];
}
else
{
	$report_ids = ( !empty($report_id) ) ? array($report_id) : array();
}


if ( isset($HTTP_GET_VARS['sort_mode']) || isset($HTTP_POST_VARS['sort_mode']) )
{
	$sort_mode = ( isset($HTTP_POST_VARS['sort_mode']) ) ? htmlspecialchars($HTTP_POST_VARS['sort_mode']) : htmlspecialchars($HTTP_GET_VARS['sort_mode']);
}
else
{
	$sort_mode = 'report_date';
}


if ( isset($HTTP_POST_VARS['sort_order']) )
{
	$sort_order = ($HTTP_POST_VARS['sort_order'] == 'ASC') ? 'ASC' : 'DESC';
}
elseif ( isset($HTTP_GET_VARS['sort_order']) )
{
	$sort_order = ($HTTP_GET_VARS['sort_order'] == 'ASC') ? 'ASC' : 'DESC';
}
else
{
	$sort_order = 'DESC';
}


//
// Reports sorting
//
$mode_types_text = array($lang['Report_date'], $lang['Status'], $lang['Action_date']);
$mode_types = array('report_date', 'report_status', 'action_date');

$select_sort_mode = '<select name="sort_mode">';
for ($i = 0; $i < count($mode_types_text); $i++)
{
	$selected = ( $sort_mode == $mode_types[$i] ) ? ' selected="selected"' : '';
	$select_sort_mode .= '<option value="' . $mode_types[$i] . '"' . $selected . '>' . $mode_types_text[$i] . '</option>';
}
$select_sort_mode .= '</select>';

$select_sort_order = '<select name="sort_order">';
if ($sort_order == 'ASC')
{
	$select_sort_order .= '<option value="ASC" selected="selected">' . $lang['Sort_Ascending'] . '</option><option value="DESC">' . $lang['Sort_Descending'] . '</option>';
}
else
{
	$select_sort_order .= '<option value="ASC">' . $lang['Sort_Ascending'] . '</option><option value="DESC" selected="selected">' . $lang['Sort_Descending'] . '</option>';
}
$select_sort_order .= '</select>';


//
// main code
//

// check for open/close report
if ( ($mode == 'close' || $mode == 'open') && !empty($report_ids) )
{
	if ( isset($HTTP_POST_VARS['cancel']) )
	{
		redirect($phpbb_root_path . "viewpost_reports.$phpEx");
	}

	// fill the report information panel
	$report_details = array();
	$report_details = get_report_details('', $report_ids);

	// maybe we have to add a check here if the report is already closed/opened

	// check if the user pressed the submit button
	if ( $submit )
	{
		$report_actions = ( !empty($HTTP_POST_VARS['report_actions']) ) ? $HTTP_POST_VARS['report_actions'] : array();
		$action_comments = ( !empty($HTTP_POST_VARS['action_comments']) ) ? htmlspecialchars(trim($HTTP_POST_VARS['action_comments'])) : '';

		// create the report actions
		$report_action_ids = array();
		foreach($report_actions as $row)
		{
			$report_action_ids[] = intval($row);
		}
		$report_action = implode(',', $report_action_ids);

		// check if no action was selected or no comments were entered when required
		if ( empty($report_actions) || ( empty($action_comments) && data_comments_required($report_action_ids, 'action') ) )
		{
			$message = ( empty($report_actions) ) ? $lang['Report_action_not_selected'] : $lang['Comments_not_entered'];

			$action = ( $mode == 'close' ) ? $lang['Close'] : $lang['Open'];

			// use the js history for multiple reports
			if ( count($report_ids) == 1)
			{
				$link = '<a href="' . append_sid($phpbb_root_path.'viewpost_reports.'.$phpEx.'?mode='.$mode.'&amp;report='.$report_id) .'">';
			}
			else
			{
				// javascript:history.back()
				$link = '<a href="javascript:history.go(-1)">';
			}

			$message .= '<br /><br />' . sprintf($lang['Click_return_action'], $link, '</a>', $action);
			message_die(GENERAL_MESSAGE, $message);
		}

		// change the mode when the user has choosen to close the report after reopening it
		if ( isset($HTTP_POST_VARS['close_report']) && $mode == 'open')
		{
			$mode = 'close';
			$action_comments = 'Reopened and Closed by ' . $userdata['username'] . '.\n' . $action_comments;
		}

		// process all the reports
		for ( $i = 0; $i < count($report_ids); $i++)
		{
			// create here some multi-used variables

			//
			// send the PMs
			//

			// we use bbcode because we disabled html in pms
			// maybe we should enable html or give the link in plain text?
			$report_link = '[url=' . get_server_url('viewtopic') . '?' . POST_POST_URL . '=' . $report_details[$i]['post_id'].'#'.$report_details[$i]['post_id'] . ']' . $report_details[$i]['topic_title'] . '[/url]';

			if ( isset($HTTP_POST_VARS['inform_reporter_pm']) )
			{
				$reporter_subject = sprintf($lang['pm_reporter_subject'], $report_details[$i]['topic_title']);
				$reporter_message = sprintf($lang['pm_reporter_message'], $report_details[$i]['reporter'], create_date($board_config['default_dateformat'], $report_details[$i]['report_time'], $board_config['board_timezone']), $report_link, $report_details[$i]['poster'], create_report_data($report_action, 'action'), $action_comments);

				insert_pm($userdata['user_id'], $report_details[$i]['report_user_id'], $reporter_message, $reporter_subject, 0, 1, 1, 0);
			}

			if ( isset($HTTP_POST_VARS['inform_poster_pm']) && $report_details[$i]['poster_id'] != ANONYMOUS )
			{
				$poster_subject = sprintf($lang['pm_poster_subject'], $report_details[$i]['topic_title']);
				$poster_message = sprintf($lang['pm_poster_message'], $report_details[$i]['poster'], create_date($board_config['default_dateformat'], $report_details[$i]['report_time'], $board_config['board_timezone']), $report_link, create_report_data($report_action, 'action'), $action_comments);

				insert_pm($userdata['user_id'], $report_details[$i]['poster_id'], $poster_message, $poster_subject, 0, 1, 1, 0);
			}

			//
			// send the Emails
			//
			if ( isset($HTTP_POST_VARS['inform_reporter_email']) )
			{
				$data = array( 'reporter'	=> $report_details[$i]['reporter'],
									'poster'		=> $report_details[$i]['poster'],
									'date'		=> create_date($board_config['default_dateformat'], $report_details[$i]['report_time'], $board_config['board_timezone']),
									'comments'	=> sprintf($lang['Actions_and_comments'], create_report_data($report_action, 'action'), $action_comments));

				send_email($report_details[$i]['reporter_email'], 'report_action_reporter', $report_details[$i]['post_id'], 'Reply to reported post - '.$report_details[$i]['topic_title'], $data);
			}

			if ( isset($HTTP_POST_VARS['inform_poster_email']) && $report_details[$i]['poster_id'] != ANONYMOUS )
			{
				$data = array( 'poster'		=> $report_details[$i]['poster'],
									'date'		=> create_date($board_config['default_dateformat'], $report_details[$i]['report_time'], $board_config['board_timezone']),
									'comments'	=> sprintf($lang['Actions_and_comments'], create_report_data($report_action, 'action'), $action_comments));

				send_email($report_details[$i]['poster_email'], 'report_action_poster', $report_details[$i]['post_id'], 'Reported post - '.$report_details[$i]['topic_title'], $data);
			}

			//
			// Store the report actions
			//
			insert_report_action($report_details[$i]['report_id'], $userdata['user_id'], $report_action, $action_comments, $mode);
		}

		// remove report status from posts if close was selected
		if ( $mode == 'close' )
		{
			remove_post_report_status($report_ids);
		}

		$message =  $lang['Close_success'] . '<br /><br />' . sprintf($lang['Click_return_reports'], '<a href="' . append_sid($phpbb_root_path . "viewpost_reports.$phpEx") . '">', '</a>');
		message_die(GENERAL_MESSAGE, $message);

	}
	else
	{

		// show form to add comments about report
		$page_title = $lang['Report_posts'];
		include($phpbb_root_path . 'includes/page_header.'.$phpEx);

		// create the predefined actions menu
		$report_menu_actions = array();
		$report_menu_actions = get_reports_data('actions');

		//$report_actions = '';
		for($i = 0; $i < count($report_menu_actions); $i++)
		{
			//$report_actions .= '<input type="checkbox" name="report_actions[]" value="' . $report_menu_actions[$i]['data_id'] . '" />' . $report_menu_actions[$i]['data_name'] . ( ( $report_menu_actions[$i]['data_comments'] ) ? ' (*)': '' ) . '<br />';

			$template->assign_block_vars("report_actions", array(
				'DATA_ID'	=> $report_menu_actions[$i]['data_id'],
				'DATA_NAME'	=> $report_menu_actions[$i]['data_name'] . ( ( $report_menu_actions[$i]['data_comments'] ) ? ' (*)': '' ),
				'DATA_DESC'	=> ( $reports_config['show_action_desc'] ) ? '<br />' . $report_menu_actions[$i]['data_desc'] : ''
				)
			);

		}

		// create the hidden report id fields
		// used mainly for multiple actions
		$hidden_fields = '';
		foreach ( $report_ids as $row)
		{
			$hidden_fields .= '<input type="hidden" name="p[]" value="'.$row.'">';
		}

		// start the output
		$template->set_filenames(array(
			'body' => 'report_action.tpl')
		);

		$template->assign_vars(array(
			'TEMPLATE_NAME'	=> rp_get_template_name($userdata['user_style']),

			'TOPIC_TITLE'	=> $topic_title,	// get it
			'POST_ID'		=> $post_id,	// get it

			'REPORT_COMMENTS' => $report_comments,
			//'REPORT_ACTIONS'	=> $report_actions,

			'REPORT_ACTION'	=> (( $mode == 'close' ) ? $lang['Close'] : $lang['Reopen']) . (( count($report_ids) > 1 ) ? ' (Multiple)' : '' ),

			'U_VIEW_TOPIC'	=> append_sid($phpbb_root_path . "viewtopic.$phpEx?" . POST_POST_URL . "=$post_id#$post_id"),

			'L_REPORT_POSTS'			=> $lang['Report_posts'],
			'L_REPORT_ACTION_COMMENTS'	=> $lang['Report_action_comments'],
			'L_ACTION'     => $lang['Action'],
			'L_COMMENTS'	=> $lang['Comments'],
			'L_COMMENTS_REQUIRED' => $lang['Comments_required'],
			'L_LAST_ACTION_COMMENTS' => $lang['Last_action_comments'],
			'L_LAST_ACTION_COMMENTS_EXPLAIN' => $lang['Last_action_comments_explain'],

			'L_SUBMIT'		=> $lang['Submit'],
			'L_CANCEL'		=> $lang['Cancel'],

			'L_PREVIOUS_COMMENTS'   => $lang['Previous_comments'],

			'L_REPORT_INFO'		=> $lang['Report_information'],
			'L_POST_INFO'			=> $lang['Post_information'],
			'L_POSTER_INFO'		=> $lang['Poster_information'],
			'L_ACTION_INFO'		=> $lang['Action_information'],

			'REPORT_POSTS_VERSION'	=> REPORT_POSTS_VERSION,

			'S_MODS_PM_DISABLED'		=> ( !$reports_config['allow_mods_pm'] ) ? 'disabled="disabled"' : '',
			'S_MODS_EMAIL_DISABLED'	=> ( !$reports_config['allow_mods_email'] ) ? 'disabled="disabled"' : '',

			'S_HIDDEN_FIELDS'	=> $hidden_fields,
			'S_ACTION'			=> append_sid($phpbb_root_path . "viewpost_reports.$phpEx?mode=$mode")
			)
		);

		// display the close checkbox when reopening
		if ( $mode == 'open' )
		{
			$template->assign_block_vars("close_report", array(
				)
			);
		}

		// get the mod panels
		$panels = array();
		$panels = get_panels('mod');

		// fix the panels
		$enabled_panel = -1;

		for ( $i = 0 ; $i < count($panels); $i++ )
		{
			// store the 1st enabled panel
			if ( $panels[$i]['panel_enabled'] == 1 && $enabled_panel == -1 )
			{
				$enabled_panel = $i;
			}

			// disable 'poster' & 'action' panels when we have more than 1 report
			if ( count($report_ids) > 1 && ( $panels[$i]['panel_name'] == 'poster_info' || $panels[$i]['panel_name'] == 'action_info' ) )
			{
				// disable it
				$panels[$i]['panel_enabled'] = 0;

				// if this panel is the active one
				// make the 1st enabled panel be the active one
				if ( $panels[$i]['panel_active'] && $enabled_panel != -1 )
				{
					$panels[$enabled_panel]['panel_active'] = 1;
					$panels[$i]['panel_active'] = 0;
				}
			}
		}

		$panel_counter = 0;

		// process each panel
		for ( $i = 0 ; $i < count($panels); $i++ )
		{

			if ( $panels[$i]['panel_enabled'] )
			{
				// create the panels js array
				$template->assign_block_vars("panels", array(
					'COUNTER'		=> $panel_counter,
					'PANEL_NAME'	=> $panels[$i]['panel_name']
					)
				);

				$panel_counter++;

				// initialize the panels & make the 1st one active
				$template->assign_block_vars($panels[$i]['panel_name'], array(
					'TAB_CLASS'			=> ( $panels[$i]['panel_active'] ) ? 'tab activeTab' : 'tab',
					'PANEL_NAME'		=> $panels[$i]['panel_name'],
					'PANEL_DISPLAY'	=> ( $panels[$i]['panel_active'] ) ? 'block' : 'none'
					)
				);

			// fill the panels with data
			switch ( $panels[$i]['panel_name'] )
			{
				case 'report_info':

					if ( !empty($report_details) )
					{
						for ($j = 0; $j < count($report_details); $j++)
						{
							$template->assign_block_vars("report_info.details", array(
								'ROW_CLASS'	=> ( !($j % 2) ) ? $theme['td_class1'] : $theme['td_class2'],
								'REPORTER'	=> '<a href="' . $phpbb_root_path . "profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '=' . $report_details[$j]['report_user_id'] . '">' . $report_details[$j]['reporter'] . '</a>',
								'DATE'		=> create_date($board_config['default_dateformat'], $report_details[$j]['report_time'], $board_config['board_timezone']),
								'REASONS'	=> create_report_data($report_details[$j]['report_reason'], 'reason'),
								'COMMENTS'	=> str_replace("\n", "<br />", $report_details[$j]['report_comments']),
								'STATUS'		=> ( $report_details[$j]['report_status'] == REPORT_POST_CLOSED ) ? $lang['Closed'] : ( ( $report_details[$j]['report_status'] == REPORT_POST_NEW ) ? $lang['Opened'] : $lang['Reopened'])
								)
							);
						}
					}
					else
					{
						$template->assign_block_vars("report_info.null", array(
							)
						);
					}

					break;

				case 'post_info':

					// fill the post information panel
					$post_details = array();
					$post_details = rp_get_post_details('', $report_ids, 'report');

					//print_r($post_details);

					if ( count($post_details) > 1 )
					{
						$block_var = "post_info.multiple_details";
						$template->assign_block_vars("post_info.multiple", array(
							)
						);
					}
					else
					{
						$block_var = "post_info.details" ;
					}

					if ( !empty($post_details) )
					{
						for ($j = 0; $j < count($post_details); $j++)
						{
							$template->assign_block_vars($block_var, array(
								'ROW_CLASS'		=> ( !($j % 2) ) ? $theme['td_class1'] : $theme['td_class2'],
								'POSTER_NAME'	=> '<a href="' . $phpbb_root_path . "profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '=' . $post_details[$j]['poster_id'] . '">' . $post_details[$j]['poster'] . '</a>',
								'POST_DATE'		=> $post_details[$j]['post_date'],
								'POST_SUBJECT'	=> '<a href="' . append_sid($phpbb_root_path . "viewtopic.$phpEx?" . POST_POST_URL . '=' . $post_details[$j]['post_id'].'#'.$post_details[$j]['post_id']) . '" target="_blank">' . $post_details[$j]['post_subject'] . '</a>',
								'MESSAGE'		=> $post_details[$j]['message']
								)
							);
						}
					}
					else
					{
						$template->assign_block_vars("post_info.null", array(
							)
						);
					}

					break;

				case 'poster_info':

					$report_details = $report_details[0];

					// fill the poster information panel
					// maybe we have to add some user information too
					$poster_details = array();
					$poster_details = get_report_details('', $report_details['poster_id'], 'poster');

					//print_r($poster_details);

					if ( !empty($poster_details) )
					{
						$template->assign_vars(array(
							'NO_OF_REPORTS'	=> count($poster_details),
							'POSTER_NAME'		=> '<a href="' . $phpbb_root_path . 'profile.'.$phpEx . '?mode=viewprofile&amp;' . POST_USERS_URL . '=' . $report_details['poster_id'] . '">' . $report_details['poster'] . '</a>'
							)
						);

						for ($j = 0; $j < count($poster_details); $j++)
						{
							$action_details = array();
							$action_details = get_report_action_details('single', $poster_details[$j]['report_id'], 1);

							$template->assign_block_vars("poster_info.details", array(
								'ROW_CLASS'			=> ( !($j % 2) ) ? $theme['td_class1'] : $theme['td_class2'],
								'REPORTER'			=> '<a href="' . $phpbb_root_path . "profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '=' . $poster_details[$j]['report_user_id'] . '">' . $poster_details[$j]['reporter'] . '</a>',
								'DATE'				=> create_date($board_config['default_dateformat'], $poster_details[$j]['report_time'], $board_config['board_timezone']),
								'POST_SUBJECT'		=> '<a href="' . append_sid($phpbb_root_path . 'viewtopic.'.$phpEx . '?' . POST_POST_URL . '=' . $poster_details[$j]['post_id'].'#'.$poster_details[$j]['post_id']) . '" target="_blank">' . $poster_details[$j]['topic_title'] . '</a>',
								'REASONS'			=> create_report_data($poster_details[$j]['report_reason'], 'reason'),
								'ACTIONS'			=> ( empty($action_details) ) ? '-' : (( $action_details['action_status'] == REPORT_POST_CLOSED) ? $lang['Closed'] : $lang['Reopened']) . ' (' . create_report_data($action_details['action'], 'action') . ') by ' . $action_details['moderator']
								)
							);
						}
					}
					else
					{
						$template->assign_block_vars("poster_info.null", array(
							)
						);
					}

					break;

				case 'action_info':

					// fill the previous report actions information panel
					$action_details = array();
					$action_details = get_report_action_details('', $report_id);

					if ( !empty($action_details) )
					{
						for ($j = 0; $j < count($action_details); $j++)
						{
							$template->assign_block_vars("action_info.details", array(
								'ROW_CLASS'			=> ( !($j % 2) ) ? $theme['td_class1'] : $theme['td_class2'],
								'MODERATOR'			=> '<a href="' . $phpbb_root_path . "profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '=' . $action_details[$j]['action_user_id'] . '">' . $action_details[$j]['moderator'] . '</a>',
								'ACTION_DATE'		=> create_date($board_config['default_dateformat'], $action_details[$j]['action_time'], $board_config['board_timezone']),
								'ACTIONS'			=> (( $action_details[$j]['action_status'] == REPORT_POST_CLOSED) ? $lang['Closed'] : $lang['Reopened']) . ' (' . create_report_data($action_details[$j]['action'], 'action') . ')',
								'ACTION_COMMENTS'	=> str_replace("\n", "\n<br />\n", $action_details[$j]['action_comments'])
								)
							);
						}
					}
					else
					{
						$template->assign_block_vars("action_info.null", array(
							)
						);
					}

					break;

			}	// switch ( $panels[$i]['panel_name'] )
			}	// if ( $panels[$i]['panel_enabled'] )
		}	// for ( $i = 0 ; $i < count($panels); $i++ )
	}
}
else if ( $mode == 'optout' || $mode == 'optin' )
{
	$sql = "UPDATE " . USERS_TABLE . " SET
		user_report_optout = " . (( $mode == 'optout' ) ? 1 : 0) . "
		WHERE user_id = " . $userdata['user_id'];

	if ( !$db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Could not opt status', '', __LINE__, __FILE__, $sql);
	}

	$message = $lang['Opt_success'] . '<br /><br />' . sprintf($lang['Click_return_reports'], '<a href="' . append_sid($phpbb_root_path . "viewpost_reports.$phpEx") . '">', '</a>');
	message_die(GENERAL_MESSAGE, $message);
}
else if ( $mode == 'delete' && !empty($report_ids) )
{

	// check if the user is an admin
	if ( $userdata['user_level'] != ADMIN && !$reports_config['allow_mods_delete'])
	{
		$message = $lang['Moderators_not_authorized_delete'] . '<br /><br />' . sprintf($lang['Click_return_reports'], '<a href="' . append_sid($phpbb_root_path . "viewpost_reports.$phpEx") . '">', '</a>');
		message_die(GENERAL_MESSAGE, $message);
	}

	// delete the selected reports
	delete_reports($report_ids, 'mod');

	$message =  $lang['Delete_success'] . '<br /><br />' . sprintf($lang['Click_return_reports'], '<a href="' . append_sid($phpbb_root_path . "viewpost_reports.$phpEx") . '">', '</a>');
	message_die(GENERAL_MESSAGE, $message);
}
else	// $mode = ''
{

	$page_title = $lang['View_post_reports'];
	include($phpbb_root_path . 'includes/page_header.' . $phpEx);

	$template->set_filenames(array(
		'body' => 'reports_view.tpl')
	);

	// display the delete action only if allowed
	if ( $reports_config['allow_mods_delete'] || $userdata['user_level'] == ADMIN )
	{
		$template->assign_block_vars("allow_mods_delete", array(
			)
		);
	}

	$template->assign_vars(array(
		'L_REPORT_POSTS'		=> $lang['Report_posts'],

		'L_SELECT_SORT_METHOD' => $lang['Select_sort_method'],

		'L_DISPLAY'		=> $lang['Display'],

		'L_OPEN'			=> $lang['Open'],
		'L_CLOSE'		=> $lang['Close'],
		'L_DELETE'		=> $lang['Delete'],

		'L_ALL'			=> $lang['All'],
		'L_OPENED'		=> $lang['Opened'],
		'L_CLOSED'		=> $lang['Closed'],
		'L_REOPENED'	=> $lang['Reopened'],

		'L_SORT'			=> $lang['Sort'],

		'L_POST'			=> $lang['Post'],
		'L_REPORTER'	=> $lang['Reporter'],
		'L_COMMENTS'	=> $lang['Comments'],
		'L_STATUS'		=> $lang['Status'],

		'L_ACTION'     => $lang['Action'],
		'L_LAST_ACTION_COMMENTS' => $lang['Last_action_comments'],

		'L_SELECT_ACTION'	=> $lang['Select_action'],
		'L_SUBMIT'			=> $lang['Submit'],

		'L_OPT_OUT'				=> ( $userdata['user_report_optout'] ) ? $lang['Opt_in'] : $lang['Opt_out'],
		'L_EMAIL_DISABLED'	=> ( !$reports_config['email_notification'] ) ? $lang['Email_disabled'] : '',

		'U_OPT_OUT'		=> append_sid($phpbb_root_path . "viewpost_reports.$phpEx" . (( $userdata['user_report_optout'] ) ? '?mode=optin' : '?mode=optout')),

		'REPORT_POSTS_VERSION'	=> REPORT_POSTS_VERSION,

		'S_MODE_SELECT'	=> $select_sort_mode,
		'S_ORDER_SELECT'	=> $select_sort_order,

		'S_ALL'			=> ( $status == 0 ) ? ' selected="selected"' : '',
		'S_OPEN'			=> ( $status == REPORT_POST_NEW ) ? ' selected="selected"' : '',
		'S_CLOSED'		=> ( $status == REPORT_POST_CLOSED ) ? ' selected="selected"' : '',
		'S_REOPENED'	=> ( $status == REPORT_POST_REOPENED ) ? ' selected="selected"' : '',

		'S_ACTION'		=> append_sid($phpbb_root_path . 'viewpost_reports.' . $phpEx))
	);



	$reports = array();
	$reports = get_report_details('', '', 'report', $status, '', $start, $reports_config['reports_per_page'], $sort_mode, $sort_order);

	//start the output of each report
	for ($i = 0; $i < count($reports); $i++)
	{
		if ( $reports[$i]['report_status'] == REPORT_POST_NEW )
		{
			$report_status = $lang['Opened'];
			$report_status_color = $reports_config['color_status_open'];

			$report_action = $lang['Close'];
			$mode = 'close';
		}
		elseif ( $reports[$i]['report_status'] == REPORT_POST_CLOSED )
		{
			$report_status = $lang['Closed'];
			$report_status_color = $reports_config['color_status_closed'];

			$report_action = $lang['Reopen'];
			$mode = 'open';
		}
		else
		{
			$report_status = $lang['Reopened'];
			$report_status_color = $reports_config['color_status_reopened'];

			$report_action = $lang['Close'];
			$mode = 'close';
		}

		$report_action = '<a href="'.append_sid($phpbb_root_path.'viewpost_reports.'.$phpEx.'?mode='.$mode.'&amp;report='.$reports[$i]['report_id']).'">'.$report_action.'</a>';

		$template->assign_block_vars('postrow', array(
			'ROW_CLASS'			=> ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'],

			'REPORT_ID'			=> $reports[$i]['report_id'],

			'TOPIC_TITLE'		=> $reports[$i]['topic_title'],
			'FORUM'				=> $reports[$i]['forum_name'],
			'POSTER'				=> '<a href="' . $phpbb_root_path . 'profile.'.$phpEx . '?mode=viewprofile&amp;' . POST_USERS_URL . '=' . $reports[$i]['poster_id'] . '">' . $reports[$i]['poster'] . '</a>',

			'REPORTER'			=> '<a href="' . $phpbb_root_path . 'profile.'.$phpEx . '?mode=viewprofile&amp;' . POST_USERS_URL . '=' . $reports[$i]['report_user_id'] . '">' . $reports[$i]['reporter'] . '</a>',
			'DATE'				=> create_date($board_config['default_dateformat'], $reports[$i]['report_time'], $board_config['board_timezone']),
			'REASONS'			=> create_report_data($reports[$i]['report_reason'], 'reason'),
			'COMMENTS'			=> str_replace("\n", "\n<br />\n", $reports[$i]['report_comments']),

			'STATUS'				=> $report_status,
			'STATUS_COLOR'		=> $report_status_color,

			'U_VIEW_POST'		=> append_sid($phpbb_root_path.'viewtopic.'.$phpEx . '?' . POST_POST_URL . '='.$reports[$i]['post_id'].'#'.$reports[$i]['post_id']),
			'U_REPORT_ACTION'	=> $report_action
			)
		);

		$actions = array();
		$actions = get_report_action_details('', $reports[$i]['report_id'], $reports_config['actions_per_report']);

		// start the output of each action for a specific report
		for ($j = 0; $j < count($actions); $j++)
		{
			$template->assign_block_vars('postrow.action_row', array(
				'MODERATOR'	=> '<a href="' . $phpbb_root_path . "profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '=' . $actions[$j]['action_user_id'] . '">' . $actions[$j]['moderator'] . '</a>',
				'DATE'		=> create_date($board_config['default_dateformat'], $actions[$j]['action_time'], $board_config['board_timezone']),
				'ACTIONS'	=> (( $actions[$j]['action_status'] == REPORT_POST_CLOSED ) ? $lang['Closed']: $lang['Reopened']) . ' ('.create_report_data($actions[$j]['action'], 'action').')',
				'COMMENTS'	=> str_replace("\n", "\n<br />\n", $actions[$j]['action_comments']),
				'RULER'		=> ( $j != 0 ) ? '<hr style="color: #000; background-color: #000; height: 2px;" />' : ''
				)
			);
		}

		// show a 'close report' message when no actions were found
		if ( count($actions) == 0 )
		{
			$template->assign_block_vars('postrow.close', array(
				'U_REPORT_CLOSE'	=> '<a href="'.append_sid($phpbb_root_path . "viewpost_reports.$phpEx?mode=$mode&amp;report=" . $reports[$i]['report_id']) . '">'.$lang['Close_this_report'].'</a>'
				)
			);
		}

	}	// for ($i = 0; $i < count($reports); $i++)


	//
	// do a little bit of cleanup
	//

	// find how many reports with non-existent posts will be deleted
	$delete_ids = array();
	$delete_ids = get_reports_with_no_posts();

	if ( !empty($delete_ids) )
	{
		delete_reports($delete_ids, 'mod');
		$deleted_reports = sprintf($lang['Reports_non_existent_posts'], count($delete_ids));
	}
	else
	{
		$deleted_reports = '';
	}

	// find how many actions with non-existent reports will be deleted
	$delete_ids = array();
	$delete_ids = get_actions_with_no_reports();

	if ( !empty($delete_ids) )
	{
		delete_actions($delete_ids);
		$deleted_actions = sprintf($lang['Actions_non_existent_reports'], count($delete_ids));
	}
	else
	{
		$deleted_actions = '';
	}

	$template->assign_vars(array(
		'L_DELETED_REPORTS'	=> $deleted_reports,
		'L_DELETED_ACTIONS'	=> ( ( !empty($deleted_reports) ) ? '<br />' : '') . $deleted_actions
		)
	);

	// end of cleanup


	// create the pagination
	if ( ($reports_count = get_reports_count($status)) > 0 )
	{
		$template->assign_vars(array(
			'PAGINATION' => generate_pagination("viewpost_reports.$phpEx?status=$status", $reports_count, $reports_config['reports_per_page'], $start),
			'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $reports_config['reports_per_page'] ) + 1 ), ceil( $reports_count / $reports_config['reports_per_page'] )),

			'L_GOTO_PAGE' => $lang['Goto_page'])
		);
	}

}

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>
