<?php
/***************************************************************************
 *                             report.php
 *                             ----------
 *   begin                : Sunday, Jun 19, 2005
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: report.php,v 2.1.5.0 2005/10/28 14:18:00 chatasos Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/bbcode.'.$phpEx);
include($phpbb_root_path . 'includes/functions_report_global.'.$phpEx);
include($phpbb_root_path . 'includes/functions_report.'.$phpEx);


//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);
//
// End session management
//

//
// Language File
//
include($phpbb_root_path.'language/lang_'.$board_config['default_lang'].'/lang_report_posts.'.$phpEx);


if ( isset($HTTP_POST_VARS[POST_POST_URL]) || isset($HTTP_GET_VARS[POST_POST_URL]) )
{
	$post_id = ( !empty($HTTP_POST_VARS[POST_POST_URL]) ) ? intval($HTTP_POST_VARS[POST_POST_URL]) : intval($HTTP_GET_VARS[POST_POST_URL]);
}
else
{
	$message = 'You haven\'t selected any post.' . '<br /><br />' . sprintf($lang['Click_return_index'], '<a href="' . append_sid("index.$phpEx") . '">', '</a>');
	message_die(GENERAL_MESSAGE, $message);
}

if ( isset($HTTP_POST_VARS['report']) || isset($HTTP_GET_VARS['report']) )
{
	$report_id = ( !empty($HTTP_POST_VARS['report']) ) ? intval($HTTP_POST_VARS['report']) : intval($HTTP_GET_VARS['report']);
}
else
{
	$report_id = '';
}

if ( isset($HTTP_POST_VARS['mode']) || isset($HTTP_GET_VARS['mode']) )
{
	$mode = ( !empty($HTTP_POST_VARS['mode']) ) ? htmlspecialchars($HTTP_POST_VARS['mode']) : htmlspecialchars($HTTP_GET_VARS['mode']);
}
else
{
	$mode = '';
}

if ( $HTTP_POST_VARS['cancel'] )
{
	redirect($phpbb_root_path . "viewtopic.$phpEx?" . POST_POST_URL . "=$post_id#$post_id");
}

if ( !$userdata['session_logged_in'] )
{
	redirect($phpbb_root_path . "login.$phpEx?redirect=report.$phpEx?" . POST_POST_URL . "=$post_id");
}

// get the config
$reports_config = array();
$reports_config = get_reports_config();

// get the post details
$post_details = array();
$post_details = rp_get_post_details('single', $post_id, 'post');

// init the report details
$report_details = array();


// check if the post doesn't exist
if ( empty($post_details) )
{
	$message = 'This post doesn\'t exist.' . '<br /><br />' . sprintf($lang['Click_return_index'], '<a href="' . append_sid("index.$phpEx") . '">', '</a>');
	message_die(GENERAL_MESSAGE, $message);
}

// check if user is trying to report his own post
if ( !$reports_config['allow_users_own'] && ( $post_details['poster_id'] == $userdata['user_id'] ) )
{
	$template->assign_vars(array(
		'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("viewtopic.$phpEx?" . POST_POST_URL . "=$post_id#$post_id") . '">')
	);

	$message = 'You are not allowed to report your own posts.' . '<br /><br />' . sprintf($lang['Click_return_topic'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_POST_URL . "=$post_id#$post_id") . '">', '</a>');
	message_die(GENERAL_MESSAGE, $message);
}


// check if the post has already been reported and is still open
if ( report_exists($post_id, REPORT_POST_NEW) )
{
	// find the open report of this post made by this user, if any
	//$report_details = array();
	$report_details = get_report_details('single', $post_id, 'post', REPORT_POST_NEW, $userdata['user_id']);

	// if the reporter reported the same post again
	if ( !empty($report_details) )
	{
		//check if user is allowed to edit his report
		if ( $reports_config['allow_users_edit'] )
		{
			$mode = 'edit';
			$report_id = $report_details['report_id'];
		}
		else
		{
			$message = "You are not allowed to edit this report." . '<br /><br />' . sprintf($lang['Click_return_topic'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_POST_URL . "=$post_id#$post_id") . '">', '</a>');
			message_die(GENERAL_MESSAGE, $message);
		}

	}	// if another reporter reported the same post, check if multiple reports are allowed
	elseif ( !$reports_config['allow_multiple_reports'] )
	{
		$template->assign_vars(array(
			'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("viewtopic.$phpEx?" . POST_POST_URL . "=$post_id#$post_id") . '">')
		);

		$message = $lang['Post_already_reported'] . '<br /><br />' . sprintf($lang['Click_return_topic'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_POST_URL . "=$post_id#$post_id") . '">', '</a>');
		message_die(GENERAL_MESSAGE, $message);
	}
}


//
// main code
//

// check if the user pressed the submit button
if ( isset($HTTP_POST_VARS['submit']) )
{

	// delete the report if requested
	if ( isset($HTTP_POST_VARS['delete']) && $report_id != '' )
	{
		if ( !$reports_config['allow_users_delete'] )
		{
			$message =  'You are not allowed to delete your reports.' .'<br /><br />' . sprintf($lang['Click_return_report_post'], '<a href="' . append_sid($phpbb_root_path . "report.$phpEx?" . POST_POST_URL . "=$post_id") . '">', '</a>');
			message_die(GENERAL_MESSAGE, $message);
		}

		// maybe add a check if any action has been taken
		delete_reports($report_id, 'user');

		$message =  'Report deleted successfully.' .'<br /><br />' . sprintf($lang['Click_return_topic'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_POST_URL . "=$post_id#$post_id") . '">', '</a>');
		message_die(GENERAL_MESSAGE, $message);
	}

	if ( report_flood() )
	{
		$message =  $lang['Flood_Error'] . '<br /><br />' . sprintf($lang['Click_return_report_post'], '<a href="' . append_sid($phpbb_root_path . "report.$phpEx?" . POST_POST_URL . "=$post_id") . '">', '</a>');
		message_die(GENERAL_MESSAGE, $message);
	}

	$report_reasons = ( !empty($HTTP_POST_VARS['report_reasons']) ) ? $HTTP_POST_VARS['report_reasons'] : '';
	$report_comments = ( !empty($HTTP_POST_VARS['report_comments']) ) ? htmlspecialchars(trim($HTTP_POST_VARS['report_comments'])) : '';

	if ( empty($report_reasons) )
	{
		$message =  $lang['Report_reason_not_selected'] . '<br /><br />' . sprintf($lang['Click_return_report_post'], '<a href="' . append_sid($phpbb_root_path . "report.$phpEx?" . POST_POST_URL . "=$post_id") . '">', '</a>');
		message_die(GENERAL_MESSAGE, $message);
	}

	// create the report reasons
	$report_reason_ids = array();
	foreach($report_reasons as $row)
	{
		$report_reason_ids[] = intval($row);
	}
	$report_reason = implode(',', $report_reason_ids);

	// check if no comments were entered when required
	if ( data_comments_required($report_reason_ids, 'reason') && empty($report_comments) )
	{
		$message =  $lang['Report_reason_not_selected'] . '<br /><br />' . sprintf($lang['Click_return_report_post'], '<a href="' . append_sid($phpbb_root_path . "report.$phpEx?" . POST_POST_URL . "=$post_id") . '">', '</a>');
		message_die(GENERAL_MESSAGE, 'other selected with no comments. '.$message);
	}

	// email the report if configured so
	if ( $reports_config['email_notification'] )
	{
		$unhtml_specialchars_match = array('#&gt;#', '#&lt;#', '#&quot;#', '#&amp;#');
		$unhtml_specialchars_replace = array('>', '<', '"', '&');

		$comments = sprintf($lang['Reasons_and_comments'], create_report_data($report_reason, 'reason'), stripslashes(preg_replace($unhtml_specialchars_match, $unhtml_specialchars_replace, $report_comments)));
		send_email(get_moderators($post_details['forum_id']), 'report_post', $post_id, $lang['Report_post'].' - '.$post_details['topic_title'], array('reporter' => $userdata['username'], 'comments' => $comments));
	}

	// insert/update the report in the db
	insert_report($report_id, $post_id, $post_details['poster_id'], $userdata['user_id'], $report_reason, $report_comments);

	$template->assign_vars(array(
		'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("viewtopic.$phpEx?" . POST_POST_URL . "=$post_id#$post_id") . '" />')
	);

	$message = $lang['Post_reported'] . '<br /><br />' . sprintf($lang['Click_return_topic'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_POST_URL . "=$post_id#$post_id") . '">', '</a>');
	message_die(GENERAL_MESSAGE, $message);

}
else
{
	// show report form to user
	$page_title = $lang['Report_posts'];
	include($phpbb_root_path . 'includes/page_header.'.$phpEx);

	// get the report reasons from the db
	$report_menu_reasons = array();
	$report_menu_reasons = get_reports_data('reason');

	// create the predefined reasons menu
	//$report_reasons = '';
	for($i = 0; $i < count($report_menu_reasons); $i++)
	{
		$checked = ( $mode == 'edit' && in_array($report_menu_reasons[$i]['data_id'], explode(',', $report_details['report_reason'])) )? 'checked="checked"' : '';
		//$report_reasons .= '<input type=checkbox name="report_reasons[]" value="'.$report_menu_reasons[$i]['data_id'].'"' . $checked . '>'.$report_menu_reasons[$i]['data_name'] . ( ( $report_menu_reasons[$i]['data_comments'] ) ? ' (*)': '' ) . '<br />';

		$template->assign_block_vars("report_reasons", array(
			'DATA_ID'	=> $report_menu_reasons[$i]['data_id'],
			'CHECKED'	=> $checked,
			'DATA_NAME'	=> $report_menu_reasons[$i]['data_name'] . ( ( $report_menu_reasons[$i]['data_comments'] ) ? ' (*)': '' ),
			'DATA_DESC'	=> ( $reports_config['show_reason_desc'] ) ? '<br />' . $report_menu_reasons[$i]['data_desc'] : ''
			)
		);
	}

	// start the output
	$template->set_filenames(array(
		'body' => 'report_post.tpl')
	);

	$template->assign_vars(array(
		'TEMPLATE_NAME'	=> rp_get_template_name($userdata['user_style']),

		'L_REPORT_POSTS'		=> $lang['Report_posts'],
		'L_REPORT_TITLE'		=> ( $mode != 'edit' ) ? $lang['Report_post'] : $lang['Edit_report'],

		'L_COMMENTS'			=> $lang['Comments'],
		'L_COMMENTS_EXPLAIN'	=> $lang['Comments_explain'],
		'L_REPORT_REASONS'	=> $lang['Report_reasons'],
		'L_COMMENTS_REQUIRED'=> $lang['Comments_required'],
		'L_SUBMIT'				=> $lang['Submit'],
		'L_CANCEL'				=> $lang['Cancel'],
		'L_DELETE'				=> $lang['Delete_report'],

		'L_REPORT_INFO'		=> $lang['Report_information'],
		'L_POST_INFO'			=> $lang['Post_information'],
		'L_PREVIOUS_REPORTS'	=> $lang['Previous_reports'],

		'POST_SUBJECT'		=> $post_details['post_subject'],
		'POST_ID'			=> $post_id,
		'REPORT_COMMENTS'	=> ( $mode == 'edit' ) ? $report_details['report_comments'] : '',
		//'REPORT_REASONS'	=> $report_reasons,

		'U_VIEW_TOPIC'		=> append_sid($phpbb_root_path . "viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id"),

		'REPORT_POSTS_VERSION'	=> REPORT_POSTS_VERSION,

		'S_ACTION'		=> append_sid($phpbb_root_path . "report.$phpEx?" . POST_POST_URL . "=$post_id")
		)
	);

	// display the delete button
	if ( $mode == 'edit' && $reports_config['allow_users_delete'] )
	{
		$template->assign_block_vars("delete_report", array(
			)
		);
	}

	// get the user panels
	$panels = array();
	$panels = get_panels('user');

	// used for the js panels array
	$panel_counter = 0;

	// process each panel
	for ( $i = 0 ; $i < count($panels); $i++ )
	{
		if ( $panels[$i]['panel_enabled'] )
		{
			// create the js panels array
			$template->assign_block_vars("panels", array(
				'COUNTER'		=> $panel_counter, //$i,
				'PANEL_NAME'	=> $panels[$i]['panel_name']
				)
			);

			$panel_counter++;

			// initialize the panels & make the 1st one active
			$template->assign_block_vars($panels[$i]['panel_name'], array(
				'TAB_CLASS'			=> ( $panels[$i]['panel_active'] ) ? 'tab activeTab' : 'tab',
				'PANEL_NAME'		=> $panels[$i]['panel_name'],
				'PANEL_DISPLAY'	=> ( $panels[$i]['panel_active'] ) ? 'block' : 'none'
				)
			);

			// fill the panels with data
			switch ( $panels[$i]['panel_name'] )
			{
				case 'report_info':

					// fill the report information panel
					$report_details = array();
					$report_details = get_report_details('', $post_id, 'post');

					if ( !empty($report_details) )
					{
						$template->assign_block_vars("report_info.header", array(
							'L_REPORTED_TIMES'	=> sprintf($lang['Reported_times'], count($report_details))
							)
						);

						for ($j = 0; $j < count($report_details); $j++)
						{
							$template->assign_block_vars("report_info.details", array(
								'ROW_CLASS'	=> ( !($j % 2) ) ? $theme['td_class1'] : $theme['td_class2'],
								'REPORTER'	=> '<a href="' . $phpbb_root_path . 'profile.'.$phpEx . '?mode=viewprofile&amp;' . POST_USERS_URL . '=' . $report_details[$j]['report_user_id'] . '">' . $report_details[$j]['reporter'] . '</a>',
								'DATE'		=> create_date($board_config['default_dateformat'], $report_details[$j]['report_time'], $board_config['board_timezone']),
								'REASONS'	=> create_report_data($report_details[$j]['report_reason'], 'reason'),
								'COMMENTS'	=> str_replace("\n", "<br />", $report_details[$j]['report_comments']),
								'STATUS'		=> ( $report_details[$j]['report_status'] == REPORT_POST_CLOSED ) ? $lang['Closed'] : ( ( $report_details[$j]['report_status'] == REPORT_POST_NEW ) ? $lang['Opened'] : $lang['Reopened'])
								)
							);
						}
					}
					else
					{
						$template->assign_block_vars("report_info.null", array(
							)
						);
					}

					break;

				case 'post_info':

					// maybe we should display the action details for each report about this specific post
					// but they may include actions to other users, so maybe we shouldn't ? (private)

					$template->assign_block_vars("post_info.details", array(
						'POSTER_NAME'	=> '<a href="' . append_sid($phpbb_root_path . "profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '=' . $post_details['poster_id']) . '">' . $post_details['poster'] . '</a>',
						'POST_DATE'		=> $post_details['post_date'],
						'POST_SUBJECT'	=> '<a href="' . append_sid($phpbb_root_path . "viewtopic.$phpEx?" . POST_POST_URL . "=$post_id#$post_id") . '" target="_blank">' . $post_details['post_subject'] . '</a>',
						'MESSAGE'		=> $post_details['message']
						)
					);

					break;

				case 'user_reports_info':

					// fill the user's previous reports information panel
					// maybe add the actions here too, but the moderator may not want this
					$report_details = array();
					$report_details = get_report_details('', $userdata['user_id'], 'report_user');

					if ( !empty($report_details) )
					{
						$template->assign_block_vars("user_reports_info.header", array(
							'L_NUM_OF_REPORTS'	=> sprintf($lang['Num_of_reports'], count($report_details))
							)
						);

						for ($j = 0; $j < count($report_details); $j++)
						{
							$template->assign_block_vars("user_reports_info.details", array(
								'ROW_CLASS'			=> ( !($j % 2) ) ? $theme['td_class1'] : $theme['td_class2'],
								'POST'				=> '<a href="' . append_sid($phpbb_root_path . 'viewtopic.'.$phpEx . '?' . POST_POST_URL . '=' . $report_details[$j]['post_id'].'#'.$report_details[$j]['post_id']) . '">' . $report_details[$j]['topic_title']. '</a>',
								'DATE'				=> create_date($board_config['default_dateformat'], $report_details[$j]['report_time'], $board_config['board_timezone']),
								'REASONS'			=> create_report_data($report_details[$j]['report_reason'], 'reason'),
								'COMMENTS'			=> str_replace("\n", "<br />", $report_details[$j]['report_comments'])
								)
							);
						}
					}
					else
					{
						$template->assign_block_vars("user_reports_info.null", array(
							)
						);
					}

				break;
			}	// switch ( $panels[$i]['panel_name'] )
		}	// if ( $panels[$i]['panel_enabled'] )
	}	// for ( $i = 0 ; $i < count($panels); $i++ )

}

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);


?>
