<?php
/***************************************************************************
 *                          functions_report_global.php
 *                          ---------------------------
 *   begin                : Sunday, Jun 19, 2005
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: functions_report_global.php,v 2.1.5.0 2005/10/28 14:18:00 chatasos Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *
 ***************************************************************************/


define('REPORT_POSTS_VERSION', '2.1.5 (alpha)');

// reports data codes
define('REPORT_CODE_REASON', 1);
define('REPORT_CODE_ACTION', 2);

// Report posts status
define('REPORT_POST_NEW', 1);
define('REPORT_POST_CLOSED', 2);
define('REPORT_POST_REOPENED', 3);


//
// functions
//

// Read the config parameters
function get_reports_config()
{
	global $db;

	// get the config parameters
	$reports_config = array();

	$sql = "SELECT *
		FROM " . REPORTS_CONFIG_TABLE;

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(CRITICAL_ERROR, "Could not query config information", "", __LINE__, __FILE__, $sql);
	}

	while ( $row = $db->sql_fetchrow($result) )
	{
		$reports_config[$row['config_name']] = $row['config_value'];
	}

	return $reports_config;
}


// get the number of open/closed reports for the forums the user has moderator rights
function get_reports_count($status = REPORT_POST_NEW)
{
	global $db;

	$forum_ids = array();
	$forum_ids = get_forums_auth_mod();

	// if the user is not a moderator return 0
	// normally this shouldn't happen since we are checking it while calling the function
	if ( empty($forum_ids) )
	{
		return 0;
	}
	else
	{
		$forum_sql = ' AND p.forum_id IN (' . implode(',', $forum_ids) . ')';
	}

	$status_sql = ( $status != '' ) ? ' AND pr.report_status = ' . intval($status) : '';

	// get the number of open reports for all the forums the user is a moderator
	$sql = "SELECT COUNT(pr.report_id) as total_reports
		FROM " . REPORTS_POSTS_TABLE . " pr, " . POSTS_TABLE . " p
		WHERE pr.post_id = p.post_id
			$status_sql
			$forum_sql";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not get reports count', '', __LINE__, __FILE__, $sql);
	}
	$row = $db->sql_fetchrow($result);

	return ( $row['total_reports'] ) ? intval($row['total_reports']) : 0;
}


// get the forums where the user is a moderator
function get_forums_auth_mod()
{
	global $userdata;

	$auth = auth(AUTH_MOD, AUTH_LIST_ALL, $userdata);

	// create an array to store the moderated forums
	$forums_auth = array();

	while ( list($forum) = each($auth) )
	{
		if ( $auth[$forum]['auth_mod'] )
		{
			$forums_auth[] = $forum;
		}
	}

	return $forums_auth;
}

?>
