<?php
/***************************************************************************
 *                            functions_report.php
 *                            --------------------
 *   begin                : Sunday, Jun 19, 2005
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: functions_report.php,v 2.1.5.0 2005/11/06 14:18:00 chatasos Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *
 ***************************************************************************/


//
// functions
//


// Get template name
function rp_get_template_name($style)
{
	global $db, $board_config;

	$sql = "SELECT template_name
		FROM " . THEMES_TABLE . "
		WHERE themes_id = " . intval($style);

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(CRITICAL_ERROR, 'Could not query database for theme info');
	}

	if ( !($row = $db->sql_fetchrow($result)) )
	{
		if ( $board_config['default_style'] != '' && $board_config['default_style'] != $style )
		{
			$template_name = rp_get_template_name($board_config['default_style']);
		}
		else
		{
			$template_name = 'subSilver';
			//message_die(CRITICAL_ERROR, 'Could not get template name for themes_id '.$style);
		}
	}
	else
	{
		$template_name = $row['template_name'];
	}

	return $template_name;
}


// convert the panel config string parameter to the appropriate array
// config parameter is like 'report_info,1,1|post_info,1,0'
//
// input:
//	$mode = 'user' or 'mod' or string (=> use $mode itself)
//
// output:
// array containing key/value pairs
function get_panels($mode)
{
	global $reports_config;

	if ( $mode == 'user' )
	{
		$mode = $reports_config['user_panels'];
	}
	elseif (  $mode == 'mod' )
	{
		$mode = $reports_config['mod_panels'];
	}

	$panels_ary = array();
	$panels_ary = explode('|', $mode);

	$i = 0;
	$panels = array();
	foreach ( $panels_ary as $panel )
	{
		list($panels[$i]['panel_name'], $panels[$i]['panel_enabled'], $panels[$i]['panel_active']) = explode(',', $panel);
		$i++;
	}

	return $panels;
}

// convert panels array to a string
function panels_to_string($panels)
{
	$string = '';

	foreach ( $panels as $panel )
	{
		$temp = '';
		foreach ( $panel as $key => $value )
		{
			$temp .= (( $temp == '' ) ? '' : ',' ) . $value;
		}

		$string .= (( $string == '' ) ? '' : '|' ) . $temp;
	}

	return $string;
}


// get the default panels
function get_default_panels($mode)
{

	$panels = array('report_info', 'post_info', 'user_reports_info', 'poster_info', 'action_info');

	foreach ( $panels as $panel )
	{
		$$panel = array(
							'panel_name' => $panel,
							'panel_enabled' => ( $panel == 'report_info') ? 1 : 0 ,
							'panel_active'	=>	1
							);
	}

	$user_panels = array(
								$report_info,
								$post_info,
								$user_reports_info
								);

	$mod_panels = array(
								$report_info,
								$post_info,
								$poster_info,
								$action_info
								);

	return ( $mode == 'user' ) ? $user_panels : $mod_panels;

}

// Create the panel config
//
// input:
// $mode = 'user' or 'mod'
// $panel_enabled_ary = array containing the enabled panel names
// $panel_active = string containing the active panel name
//
// output:
// string containing the config var
function create_panel_config($mode, $panel_enabled_ary, $panel_active)
{
		$panels = get_default_panels($mode);

		// find which panels are enabled and which one is active
		$nothing_active = true;
		for ( $i = 0; $i < count($panels); $i++ )
		{
			if ( in_array($panels[$i]['panel_name'], $panel_enabled_ary) )
			{
				$panels[$i]['panel_enabled'] = 1;
			}
			else
			{
				$panels[$i]['panel_enabled'] = 0;
			}

			if ( $panels[$i]['panel_name'] == $panel_active && $panels[$i]['panel_enabled'] )
			{
				$panels[$i]['panel_active'] = 1;
				$nothing_active = false;
			}
			else
			{
				$panels[$i]['panel_active'] = 0;
			}
		}

		// if we don't find anything active and we have at least one enabled,
		// find the 1st one enabled and make it active
		if ( $nothing_active && count($panel_enabled_ary) )
		{
			for ( $i = 0; $i < count($panels); $i++ )
			{
				if ( $panels[$i]['panel_enabled'] )
				{
					$panels[$i]['panel_active'] = 1;
					break;
				}
			}
		}

		//echo "<hr />"; print_r($panels);
		return panels_to_string($panels);
}

// Get the reports data
//
// input:
// $code = 'reason' or 'action'
// $id = get the details of a specific reason/action
//
// output:
// array containing all records sorted by order
function get_reports_data($code, $id = '')
{
	global $db;

	if ( $id == '' )
	{
		$sql = "SELECT data_id, data_name, data_desc, data_order, data_comments
			FROM " . REPORTS_DATA_TABLE . "
			WHERE data_code = " . (( $code == 'reason' ) ? REPORT_CODE_REASON : REPORT_CODE_ACTION ) . "
			ORDER BY data_order ASC";
	}
	else
	{
		$sql = "SELECT data_id, data_name, data_desc, data_order, data_code, data_comments
			FROM " . REPORTS_DATA_TABLE . "
			WHERE data_id = " . intval($id);
	}

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query reports data information', '', __LINE__, __FILE__, $sql);
	}

	$data = array();
	while ( $row = $db->sql_fetchrow($result) )
	{
		$data[] = $row;
	}

	return ( $id != '' && !empty($data[0]) ) ? $data[0] : $data;
}

// show the report data
// admin only
//
// input:
// $code = 'reason' or 'action'
//
function show_reports_data($code)
{
	global $template, $theme, $lang, $phpEx;

	$data_ary = get_reports_data($code);

	if ( !empty($data_ary) )
	{
		$template->assign_block_vars("data", array(
			'L_CODE'	=> $lang['Report_'.$code.'s'],
			'CODE'	=> $code
			)
		);

		for ($i = 0; $i < count($data_ary); $i++)
		{
			$move_up = '<a href="' . append_sid("admin_report_posts.$phpEx?mode=data&amp;param=data_order&amp;move=-15&amp;data_id=".$data_ary[$i]['data_id']) . '">' . $lang['Move_up'] . '</a>';
			$move_down = '<a href="' . append_sid("admin_report_posts.$phpEx?mode=data&amp;param=data_order&amp;move=15&amp;data_id=".$data_ary[$i]['data_id']) . '">' . $lang['Move_down'] . '</a>';

			$template->assign_block_vars("data.details", array(
				'ROW_CLASS'		=> ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'],

				'CODE'	=> $code,

				'NAME'	=> $data_ary[$i]['data_name'],
				'DESC'	=> $data_ary[$i]['data_desc'],

				'MOVE_UP'	=> ( $i != 0 ) ? $move_up . '<br />' : '',
				'MOVE_DOWN'	=> ( $i != count($data_ary) - 1 ) ? $move_down : '',

				'ID'		=> $data_ary[$i]['data_id'],

				'CHECKED'	=> ( $data_ary[$i]['data_comments'] ) ? 'checked="checked"' : '',

				'U_EDIT'	=> append_sid("admin_report_posts.$phpEx?mode=data&amp;param=edit&amp;data_id=" . $data_ary[$i]['data_id']),
				'U_DELETE'	=> append_sid("admin_report_posts.$phpEx?mode=data&amp;param=delete&amp;data_id=" . $data_ary[$i]['data_id']),
				)
			);
		}
	}

	return;
}

// renumber the order of reasons/actions
function renumber_order($code)
{
	global $db;

	$sql = "SELECT * FROM " . REPORTS_DATA_TABLE . "
	WHERE data_code = " . ( ( $code == 'reason') ? REPORT_CODE_REASON : REPORT_CODE_ACTION ) . "
		ORDER BY data_order ASC";

	if ( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't get list of data", "", __LINE__, __FILE__, $sql);
	}

	$i = 10;

	while ( $row = $db->sql_fetchrow($result) )
	{
		$sql = "UPDATE " . REPORTS_DATA_TABLE . "
			SET data_order = $i
			WHERE data_id = " . $row['data_id'];

		if ( !$db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Couldn't update order fields", "", __LINE__, __FILE__, $sql);
		}

		$i += 10;
	}

}

// get the next order
function get_next_order($code)
{
	global $db;

	$sql = "SELECT MAX(data_order) AS max_order
			FROM " . REPORTS_DATA_TABLE . "
				WHERE data_code = " . ( ( $code == 'reason') ? REPORT_CODE_REASON : REPORT_CODE_ACTION );

	if ( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't get order number from reports data table", "", __LINE__, __FILE__, $sql);
	}

	$row = $db->sql_fetchrow($result);

	$max_order = $row['max_order'];

	return $max_order + 10;
}


// check if specific report reasons/actions require comments

// input:
// $data = array containing the reason/action ids
// $code = 'reason' or 'action'

// output:
// true = when atleast one reason/action requires comments
// false = otherwise
function data_comments_required($data, $code)
{
	global $db;

	$sql = "SELECT data_id FROM " . REPORTS_DATA_TABLE . "
	WHERE data_code = " . (( $code == 'reason' ) ? REPORT_CODE_REASON : REPORT_CODE_ACTION ) . "
		AND data_comments = 1
		AND data_id IN (" . implode(',', $data) . ")";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query reports data information', '', __LINE__, __FILE__, $sql);
	}

	$row = $db->sql_fetchrow($result);

	return ( !empty($row) ) ? true : false;
}

// insert a report into the db
function insert_report($report_id = '', $post_id, $poster_id, $reporter_id, $report_reason, $comments)
{
	global $db;

	if ( $report_id == '' )
	{
		$sql = "INSERT INTO " . REPORTS_POSTS_TABLE . "
			(post_id, poster_id, report_user_id, report_time, report_reason, report_comments, report_status)
			VALUES ($post_id, $poster_id, $reporter_id, " . time() . ", '" . $report_reason . "', '" . str_replace("\'", "''", $comments) . "', " . REPORT_POST_NEW . ")";
	}
	else
	{
		$sql = "UPDATE " . REPORTS_POSTS_TABLE . "
		SET
			report_time = " . time() . ",
			report_reason = '$report_reason',
			report_comments = '" . str_replace("\'", "''", $comments) . "'
		WHERE report_id = $report_id";
	}

	if ( !$db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Could not insert/update report', '', __LINE__, __FILE__, $sql);
	}

	$sql = "UPDATE " . POSTS_TABLE . "
		SET post_reported = 1
		WHERE post_id = $post_id";

	if ( !$db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Could not update post status', '', __LINE__, __FILE__, $sql);
	}

	return;
}

// insert an action into the db
function insert_report_action($report_id, $user_id, $action, $comments, $mode)
{
	global $db;

	// update action status on reports_actions table
  	$sql = "INSERT INTO " . REPORTS_ACTIONS_TABLE . "
	  SET
  		report_id = $report_id,
		action_user_id = $user_id,
		action_time = " . time() . ",
		action = '" . str_replace("\'", "''", $action) . "',
		action_comments = '" . str_replace("\'", "''", $comments) . "',
		action_status = " . (( $mode == 'close' ) ? REPORT_POST_CLOSED : REPORT_POST_REOPENED );

	if ( !$db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Could not update action status', '', __LINE__, __FILE__, $sql);
	}

	// update report status on reports_posts table
  	$sql = "UPDATE " . REPORTS_POSTS_TABLE . "
		SET
			report_status = " . (( $mode == 'close' ) ? REPORT_POST_CLOSED : REPORT_POST_REOPENED ) . ",
			report_action_time = " . time() . "
		WHERE report_id = $report_id";

	if ( !$db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Could not update report status', '', __LINE__, __FILE__, $sql);
	}

	return;
}

// get the moderators (+ admins) of a specific forum
function get_moderators($forum_id)
{
	global $db;

	//
	// Obtain list of moderators of each forum
	// First users, then groups ... broken into two queries
	//
	$sql = "SELECT u.user_email
		FROM " . AUTH_ACCESS_TABLE . " aa, " . USER_GROUP_TABLE . " ug, " . GROUPS_TABLE . " g, " . USERS_TABLE . " u
		WHERE aa.forum_id = $forum_id
			AND aa.auth_mod = " . TRUE . "
			AND g.group_single_user = 1
			AND ug.group_id = aa.group_id
			AND g.group_id = aa.group_id
			AND u.user_id = ug.user_id
			AND u.user_report_optout = 0
		GROUP BY u.user_id, u.username
		ORDER BY u.user_id";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query forum moderator information', '', __LINE__, __FILE__, $sql);
	}

	$moderators = array();
	while( $row = $db->sql_fetchrow($result) )
	{
		$moderators[] = $row['user_email'];
	}

	$sql = "SELECT g.group_id
		FROM " . AUTH_ACCESS_TABLE . " aa, " . USER_GROUP_TABLE . " ug, " . GROUPS_TABLE . " g
		WHERE aa.forum_id = $forum_id
			AND aa.auth_mod = " . TRUE . "
			AND g.group_single_user = 0
			AND g.group_type <> ". GROUP_HIDDEN ."
			AND ug.group_id = aa.group_id
			AND g.group_id = aa.group_id
		GROUP BY g.group_id, g.group_name
		ORDER BY g.group_id";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query forum group moderator information', '', __LINE__, __FILE__, $sql);
	}

	$groups = array();
	while( $row = $db->sql_fetchrow($result) )
	{
		$groups[] = $row['group_id'];
	}

	if ( sizeof($groups) )
	{
		$sql = "SELECT u.user_email
			FROM " . USER_GROUP_TABLE . " ug, " . GROUPS_TABLE . " g, " . USERS_TABLE . " u
			WHERE ug.group_id = g.group_id
				AND g.group_single_user = 0
				AND g.group_id IN (" . implode(',', $groups) . ")
				AND ug.user_id = u.user_id
				AND u.user_report_optout = 0";

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not query forum moderator information', '', __LINE__, __FILE__, $sql);
		}

		while( $row = $db->sql_fetchrow($result) )
		{
			if ( !in_array($row['user_email'], $moderators) )
			{
				$moderators[] = $row['user_email'];
			}
		}
	}

	// get admins too
	$sql = "SELECT user_email FROM " . USERS_TABLE . "
		WHERE user_level = " . ADMIN . "
		AND user_report_optout = 0";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query forum admin information', '', __LINE__, __FILE__, $sql);
	}

	while( $row = $db->sql_fetchrow($result) )
	{
		if ( !in_array($row['user_email'], $moderators) )
		{
				$moderators[] = $row['user_email'];
		}
	}

	return $moderators;
}

/*
// send an email
//
// input:
// $recipients = array containing all the recipient emails
// $data = array containing all extra information (key => value)
*/
function send_email($recipients, $email_template, $post_id, $email_subject, $data = array())
{
	global $phpbb_root_path, $phpEx, $board_config, $lang, $userdata, $user_ip;

	include_once($phpbb_root_path . 'includes/emailer.'.$phpEx);

	$emailer = new emailer($board_config['smtp_delivery']);

	$emailer->from($board_config['board_email']);
	$emailer->replyto($board_config['board_email']);

	if ( !is_array($recipients) )
	{
		$recipients = array($recipients);
	}

	foreach ($recipients as $email)
	{
		$emailer->bcc($email);
	}

	$emailer->use_template($email_template);
	$emailer->email_address($board_config['board_email']);
	$emailer->set_subject($email_subject);

	$email_headers = 'X-AntiAbuse: Board servername - ' . $board_config['server_name'] . "\n";
	$email_headers .= 'X-AntiAbuse: User_id - ' . $userdata['user_id'] . "\n";
	$email_headers .= 'X-AntiAbuse: Username - ' . $userdata['username'] . "\n";
	$email_headers .= 'X-AntiAbuse: User IP - ' . decode_ip($user_ip) . "\n";
	$emailer->extra_headers($email_headers);

	$emailer->assign_vars(array(
		'EMAIL_SUBJECT'	=> $email_subject,

		'SITENAME'			=> $board_config['sitename'],
		'USERNAME'			=> $userdata['username'],

		'REPORTER'			=> ( $data['reporter'] ) ? $data['reporter'] : '',
		'POSTER'				=> ( $data['poster'] ) ? $data['poster'] : '',
		'DATE'				=> ( $data['date'] ) ? $data['date'] : '',
		'COMMENTS'			=> ( $data['comments'] ) ? $data['comments'] : '',

		'EMAIL_SIG'			=> (!empty($board_config['board_email_sig'])) ? str_replace('<br />', "\n", "-- \n" . $board_config['board_email_sig']) : '',

		'U_VIEW_POST'			=> urldecode(get_server_url('viewtopic') . '?' . POST_POST_URL . "=$post_id#$post_id"),
		'U_REPORT_POSTS_CP'	=> urldecode(get_server_url('viewpost_reports'))
		)
	);

	$emailer->send();
	$emailer->reset();

	return;
}

// create the server url
function get_server_url($phpbb_file)
{
	global $board_config, $phpEx;

	$script_name = preg_replace('/^\/?(.*?)\/?$/', "\\1", trim($board_config['script_path']));
	$script_name = ( $script_name != '' ) ? $script_name . "/$phpbb_file.$phpEx" : "$phpbb_file.$phpEx";
	$server_name = trim($board_config['server_name']);
	$server_protocol = ( $board_config['cookie_secure'] ) ? 'https://' : 'http://';
	$server_port = ( $board_config['server_port'] <> 80 ) ? ':' . trim($board_config['server_port']) . '/' : '/';

	$server_url = $server_protocol . $server_name . $server_port . $script_name;

	return $server_url;
}

/*
** function : insert_pm
**
** input :
** $from_user_id = user_id of the sender
** $to_user_id = user_id of the recipient
** $message = message to be sent
** $subject = subject of the message
** $html_on = whether html parsing should be on(1) or off(0)
** $bbcode_on = whether bbcode parsing should be on(1) or off(0)
** $smilies_on = whether smilies parsing should be on(1) or off(0)
** $flood_on = whether flood control should be on(1) or off(0)
**
** output:
** $error_msg = error messages encountered
*/
function insert_pm($from_user_id, $to_user_id, $message, $subject, $html_on = 0, $bbcode_on = 1, $smilies_on = 1, $flood_on = 1)
{
	global $db, $lang, $board_config, $userdata, $user_ip, $phpbb_root_path, $phpEx;

	//
	// Is PM disabled?
	//
	if ( !empty($board_config['privmsg_disable']) )
	{
		message_die(GENERAL_MESSAGE, 'PM_disabled');
	}

	//
	// Toggles
	//
	$html_on = ( $board_config['allow_html'] ) ? $html_on : 0;
	$bbcode_on = ( $board_config['allow_bbcode'] ) ? $bbcode_on : 0;
	$smilies_on = ( $board_config['allow_smilies'] ) ? $smilies_on : 0;

	$attach_sig = $userdata['user_attachsig'];
	$user_sig = ( $userdata['user_sig'] != '' && $board_config['allow_sig'] ) ? $userdata['user_sig'] : "";

	$error = FALSE;

   if ( !$from_user_id )
   {
      $from_user_id = $userdata['user_id'];
   }

	//
	// Flood control
	//
	if ( $flood_on )
	{
		$sql = "SELECT MAX(privmsgs_date) AS last_post_time
			FROM " . PRIVMSGS_TABLE . "
			WHERE privmsgs_from_userid = " . $from_user_id;

		if ( $result = $db->sql_query($sql) )
		{
			$db_row = $db->sql_fetchrow($result);

			$last_post_time = $db_row['last_post_time'];
			$current_time = time();

			if ( ( $current_time - $last_post_time ) < $board_config['flood_interval'] )
			{
				message_die(GENERAL_MESSAGE, $lang['Flood_Error']);
			}
		}
	}
	//
	// End Flood control
	//

	if ( !empty($to_user_id) )
	{
		$to_user_id = intval($to_user_id);

		if ( $to_user_id == ANONYMOUS )
		{
			return;
		}

		$sql = "SELECT user_id, username, user_notify_pm, user_email, user_lang, user_active
			FROM " . USERS_TABLE . "
			WHERE user_id = '$to_user_id'
				AND user_id <> " . ANONYMOUS;

		if ( !($result = $db->sql_query($sql)) )
		{
			$error = TRUE;
			$error_msg = $lang['No_such_user'];
		}

		$to_userdata = $db->sql_fetchrow($result);
	}
	else
	{
		$error = TRUE;
		$error_msg .= ( ( !empty($error_msg) ) ? '<br />' : '' ) . $lang['No_to_user'];
	}

	$privmsg_subject = trim(strip_tags($subject));

	if ( $privmsg_subject == '' )
	{
		$error = TRUE;
		$error_msg .= ( ( !empty($error_msg) ) ? '<br />' : '' ) . $lang['Empty_subject'];
	}

	if ( $message != '' )
	{
		if ( !$error )
		{
			if ( $bbcode_on )
			{
				$bbcode_uid = make_bbcode_uid();
			}

			$privmsg_message = prepare_message($message, $html_on, $bbcode_on, $smilies_on, $bbcode_uid);
		}
	}
	else
	{
		$error = TRUE;
		$error_msg .= ( ( !empty($error_msg) ) ? '<br />' : '' ) . $lang['Empty_message'];
	}

	if ( $error )
	{
		message_die(GENERAL_MESSAGE, $error_msg);
		//return $error_msg;
	}

	//
	// Has admin prevented user from sending PM's?
	//
	if ( !$userdata['user_allow_pm'] )
	{
		$message = $lang['Cannot_send_privmsg'];
		message_die(GENERAL_MESSAGE, $message);
	}

	$msg_time = time();

	//
	// See if recipient is at their inbox limit
	//
	$sql = "SELECT COUNT(privmsgs_id) AS inbox_items, MIN(privmsgs_date) AS oldest_post_time
		FROM " . PRIVMSGS_TABLE . "
		WHERE ( privmsgs_type = " . PRIVMSGS_NEW_MAIL . "
				OR privmsgs_type = " . PRIVMSGS_READ_MAIL . "
				OR privmsgs_type = " . PRIVMSGS_UNREAD_MAIL . " )
			AND privmsgs_to_userid = " . $to_userdata['user_id'];

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_MESSAGE, $lang['No_such_user']);
	}

	$sql_priority = ( SQL_LAYER == 'mysql' ) ? 'LOW_PRIORITY' : '';

	if ( $inbox_info = $db->sql_fetchrow($result) )
	{
		if ( $inbox_info['inbox_items'] >= $board_config['max_inbox_privmsgs'] )
		{
			$sql = "SELECT privmsgs_id FROM " . PRIVMSGS_TABLE . "
				WHERE ( privmsgs_type = " . PRIVMSGS_NEW_MAIL . "
						OR privmsgs_type = " . PRIVMSGS_READ_MAIL . "
						OR privmsgs_type = " . PRIVMSGS_UNREAD_MAIL . "  )
					AND privmsgs_date = " . $inbox_info['oldest_post_time'] . "
					AND privmsgs_to_userid = " . $to_userdata['user_id'];
			if ( !$result = $db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, 'Could not find oldest privmsgs (inbox)', '', __LINE__, __FILE__, $sql);
			}

			$old_privmsgs_id = $db->sql_fetchrow($result);
			$old_privmsgs_id = $old_privmsgs_id['privmsgs_id'];

			$sql = "DELETE $sql_priority FROM " . PRIVMSGS_TABLE . "
				WHERE privmsgs_id = $old_privmsgs_id";

			if ( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, 'Could not delete oldest privmsgs (inbox)'.$sql, '', __LINE__, __FILE__, $sql);
			}

			$sql = "DELETE $sql_priority FROM " . PRIVMSGS_TEXT_TABLE . "
				WHERE privmsgs_text_id = $old_privmsgs_id";

			if ( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, 'Could not delete oldest privmsgs text (inbox)', '', __LINE__, __FILE__, $sql);
			}
		}
	}


	// we use str_replace("'", "''", $privmsg_subject) instead of str_replace("\'", "''", $privmsg_subject)
	// because we don't get input from an html form
	$sql_info = "INSERT INTO " . PRIVMSGS_TABLE . " (privmsgs_type, privmsgs_subject, privmsgs_from_userid, privmsgs_to_userid, privmsgs_date, privmsgs_ip, privmsgs_enable_html, privmsgs_enable_bbcode, privmsgs_enable_smilies, privmsgs_attach_sig)
		VALUES (" . PRIVMSGS_NEW_MAIL . ", '" . str_replace("'", "''", $privmsg_subject) . "', " . $from_user_id . ", " . $to_userdata['user_id'] . ", $msg_time, '$user_ip', $html_on, $bbcode_on, $smilies_on, $attach_sig)";

	if ( !($result = $db->sql_query($sql_info, BEGIN_TRANSACTION)) )
	{
		message_die(GENERAL_ERROR, "Could not insert/update private message sent info.", "", __LINE__, __FILE__, $sql_info);
	}

	$privmsg_sent_id = $db->sql_nextid();

	// we use str_replace("'", "''", $privmsg_subject) instead of str_replace("\'", "''", $privmsg_subject)
	// because we don't get input from an html form
	$sql = "INSERT INTO " . PRIVMSGS_TEXT_TABLE . " (privmsgs_text_id, privmsgs_bbcode_uid, privmsgs_text)
		VALUES ($privmsg_sent_id, '" . $bbcode_uid . "', '" . str_replace("'", "''", $privmsg_message) . "')";

	if ( !$db->sql_query($sql, END_TRANSACTION) )
	{
		message_die(GENERAL_ERROR, "Could not insert/update private message sent text.", "", __LINE__, __FILE__, $sql);
	}

	//
	// Add to the users new pm counter
	//
	$sql = "UPDATE " . USERS_TABLE . "
		SET user_new_privmsg = user_new_privmsg + 1, user_last_privmsg = " . time() . "
		WHERE user_id = " . $to_userdata['user_id'];

	if ( !$status = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Could not update private message new/read status for user', '', __LINE__, __FILE__, $sql);
	}

	// send an email to the recipient
	if ( $to_userdata['user_notify_pm'] && !empty($to_userdata['user_email']) && $to_userdata['user_active'] )
	{
		$script_name = preg_replace('/^\/?(.*?)\/?$/', "\\1", trim($board_config['script_path']));
		$script_name = ( $script_name != '' ) ? $script_name . '/privmsg.'.$phpEx : 'privmsg.'.$phpEx;
		$server_name = trim($board_config['server_name']);
		$server_protocol = ( $board_config['cookie_secure'] ) ? 'https://' : 'http://';
		$server_port = ( $board_config['server_port'] <> 80 ) ? ':' . trim($board_config['server_port']) . '/' : '/';

		include_once($phpbb_root_path . 'includes/emailer.'.$phpEx);
		$emailer = new emailer($board_config['smtp_delivery']);

		$emailer->from($board_config['board_email']);
		$emailer->replyto($board_config['board_email']);

		$emailer->use_template('privmsg_notify', $to_userdata['user_lang']);
		$emailer->email_address($to_userdata['user_email']);
		$emailer->set_subject($lang['Notification_subject']);

		$emailer->assign_vars(array(
			'USERNAME' => $to_userdata['username'],
			'SITENAME' => $board_config['sitename'],
			'EMAIL_SIG' => (!empty($board_config['board_email_sig'])) ? str_replace('<br />', "\n", "-- \n" . $board_config['board_email_sig']) : '',

			'U_INBOX' => $server_protocol . $server_name . $server_port . $script_name . '?folder=inbox')
		);

		$emailer->send();
		$emailer->reset();
	}

	return;
}


// check if the user reported too much
function report_flood()
{
	global $db, $reports_config, $userdata;

	// check if flood interval is disabled
	if ( intval($reports_config['users_flood_interval']) == 0 )
	{
		return false;
	}

	$sql = "SELECT MAX(report_time) AS latest_time FROM " . REPORTS_POSTS_TABLE . "
		WHERE report_user_id = " . $userdata['user_id'];

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not get most recent report', '', __LINE__, __FILE__, $sql);
	}
	$row = $db->sql_fetchrow($result);

	if ( ( time() - $row['latest_time'] ) < intval($reports_config['users_flood_interval']) )
	{
		return true;
	}
	else
	{
		return false;
	}
}


// check if a post has already been reported
// each post can have only one report (per user) open at any time
function report_exists($post_id, $status = '')
{
	global $db;

	$status_sql = " AND report_status = " . (( $status != '' ) ?  $status : '');

	$sql = "SELECT report_id FROM " . REPORTS_POSTS_TABLE . "
		WHERE post_id = $post_id
		$status_sql";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not get report', '', __LINE__, __FILE__, $sql);
	}
	$row = $db->sql_fetchrow($result);

	return ( $row ) ? true : false;
}


// find the report post details
//
// input :
// $return = 'single' if we want only one line output
//	$id = value containing : report_id, post_id, report_user_id, poster_id
// $mode = what the value represents ('report', 'post', 'report_user', 'poster')
//	$status = the status of the report
// $reporter_id = the id of the reporter
//	$start = from which record to start
// $count = how many records to get
//
// output :
// array or single var containing all the details about one or more reports
function get_report_details($return = '', $id, $mode = 'report', $status = '', $reporter_id = '', $start = -1, $count = -1, $sort_mode = '', $sort_order = 'DESC')
{
	global $db;

	// create the main sql code
	if ( $id == '' )
	{
		// this should happen only when mode = 'report'
		$id_sql = 'WHERE rp.post_id = p.post_id';
	}
	elseif ( is_array($id) )
	{
		$id_sql =  'WHERE rp.'.$mode.'_id IN (' . implode(',', $id) . ') AND rp.post_id = p.post_id';
	}
	else
	{
		$id_sql = 'WHERE rp.'.$mode.'_id = ' . $id . ' AND rp.post_id = p.post_id';
	}

	// create some other sql
	$status_sql = ( $status != '' ) ? " AND rp.report_status = $status" : '';
	$reporter_sql = ( $reporter_id != '' ) ? " AND rp.report_user_id = $reporter_id" : '';

	$limit_sql = ($start != -1 && $count != -1 ) ? " LIMIT $start, $count" : '';

	// create the sort mode sql
	switch ( $sort_mode )
	{
		case 'report_date':
			$order_by = "rp.report_time $sort_order";
			break;
		case 'report_status':
			$order_by = "rp.report_status $sort_order";
			break;
		case 'action_date':
			$order_by = "rp.report_action_time $sort_order";
			break;
		default:
			$order_by = "rp.report_time $sort_order";
			break;
	}

	if ( $mode == 'post' || $mode == 'report_user' || $mode == 'poster' )
	{
		$sql = "SELECT rp.*, u.username as reporter, t.topic_title
			FROM " . REPORTS_POSTS_TABLE . " rp, " . USERS_TABLE . " u, " . POSTS_TABLE . " p, " . TOPICS_TABLE . " t
			$id_sql
				AND rp.report_user_id = u.user_id
				AND p.topic_id = t.topic_id
				$status_sql
				$reporter_sql
			ORDER BY $order_by
			$limit_sql";
	}
	else	// $mode = 'report' - used only by moderators
	{
		// find the forums where the user is a moderator
		$forum_ids = array();
		$forum_ids = get_forums_auth_mod();

		if ( empty($forum_ids) )
		{
			return array();
		}
		else
		{
			$forum_sql = ' AND p.forum_id IN (' . implode(',', $forum_ids) . ')';
		}

		$sql = "SELECT rp.*, u1.username as reporter, u1.user_email as reporter_email, u2.username as poster, u2.user_email as poster_email, t.topic_title, f.forum_id, f.forum_name
		FROM " . REPORTS_POSTS_TABLE . " rp, " . USERS_TABLE . " u1, " . USERS_TABLE . " u2, " . POSTS_TABLE . " p, " . TOPICS_TABLE . " t, " . FORUMS_TABLE . " f
		$id_sql
			AND rp.report_user_id = u1.user_id
			AND rp.poster_id = u2.user_id
			AND p.topic_id = t.topic_id
			AND t.forum_id = f.forum_id
			$forum_sql
			$status_sql
		ORDER BY $order_by
		$limit_sql";
	}

	//echo $sql."<hr />";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not get report details', '', __LINE__, __FILE__, $sql);
	}

	$report_details = array();
	while ( $row = $db->sql_fetchrow($result) )
	{
		$report_details[] = $row;
	}

	return ( $return == 'single' && !empty($report_details[0]) ) ? $report_details[0] : $report_details;

}

// find the report action details for a specific report
//
// input:
// $return = 'single' if we want only one line output
// $report_id = the report_id of the report
// $count =
// $sort_mode =
//
// output:
// an array containing all the report action details for this report
function get_report_action_details($return = '', $report_id, $count = '', $sort_mode = '', $sort_order = 'DESC')
{
	global $db;

	$limit_sql = ($count != '' ) ? " LIMIT $count" : '';

	// create the sort mode sql
	switch ( $sort_mode )
	{
		case 'action_date':
			$order_by = "ra.action_time $sort_order";
			break;
		default:
			$order_by = "ra.action_time $sort_order";
			break;
	}

	$sql = "SELECT ra.action_user_id, ra.action_time, ra.action, ra.action_comments, ra.action_status, u.username as moderator
		FROM " . REPORTS_ACTIONS_TABLE . " ra, " . USERS_TABLE . " u
		WHERE ra.report_id = $report_id
			AND ra.action_user_id = u.user_id
		ORDER BY $order_by
		$limit_sql";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not get report action details', '', __LINE__, __FILE__, $sql);
	}

	$action_details = array();
	while ( $row = $db->sql_fetchrow($result) )
	{
		$action_details[] = $row;
	}


	return ( $return == 'single' && !empty($action_details[0]) ) ? $action_details[0] : $action_details;
}

// find the posts details of one or more posts based on post_id or report_id
//
// input:
// $return = 'single' if we want only one line output
// $id = report_id or post_id
// $mode = 'post' (output = 1 line) or 'report' (output >= 1 lines)
//
// output:
// array containing all the details about a specific post or posts
//
function rp_get_post_details($return = '', $id, $mode = 'report')
{
	global $db, $board_config;
	global $orig_word, $replacement_word;

	if ( $mode == 'post' )
	{
		$return = 'single';
	}

	//
	// Define censored word matches
	//
	if ( empty($orig_word) && empty($replacement_word) )
	{
		$orig_word = array();
		$replacement_word = array();

		obtain_word_list($orig_word, $replacement_word);
	}

	// check if we are searching based on post_id or report_id
	if ( $mode == 'post' )
	{
		$sql = "SELECT u.username, u.user_id, p.*,  pt.post_text, pt.post_subject, pt.bbcode_uid, t.topic_title, f.forum_id, f.forum_name
		FROM " . POSTS_TABLE . " p, " . USERS_TABLE . " u, " . POSTS_TEXT_TABLE . " pt, " . TOPICS_TABLE . " t, " . FORUMS_TABLE . " f
		WHERE p.post_id = $id
			AND p.poster_id = u.user_id
			AND p.post_id = pt.post_id
			AND p.topic_id = t.topic_id
			AND p.forum_id = f.forum_id";
	}
	else	// $mode = 'report'
	{
		$id = ( !is_array($id) ) ? array($id) : $id;

		$sql = "SELECT u.username, u.user_id, p.*,  pt.post_text, pt.post_subject, pt.bbcode_uid, t.topic_title, f.forum_id, f.forum_name
		FROM " . REPORTS_POSTS_TABLE . " rp, "  . POSTS_TABLE . " p, " . USERS_TABLE . " u, " . POSTS_TEXT_TABLE . " pt, " . TOPICS_TABLE . " t, " . FORUMS_TABLE . " f
		WHERE rp.report_id IN (" . implode(',', $id) . ")
			AND rp.post_id = p.post_id
			AND p.poster_id = u.user_id
			AND p.post_id = pt.post_id
			AND p.topic_id = t.topic_id
			AND p.forum_id = f.forum_id";
	}

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain post information', '', __LINE__, __FILE__, $sql);
	}

	$post_details = array();

	while ( $row = $db->sql_fetchrow($result) )
	{

		$post_id		= $row['post_id'];
		$poster_id	= $row['user_id'];
		$poster		= $row['username'];

		$forum_id	= $row['forum_id'];
		$forum_name	= $row['forum_name'];

		$post_date	= create_date($board_config['default_dateformat'], $row['post_time'], $board_config['board_timezone']);

		$topic_title = $row['topic_title'];

		// include the topic title too
		$post_subject = $row['topic_title'] . (( $row['post_subject'] != '' && $row['post_subject'] != $row['topic_title'] ) ? ' ('.$row['post_subject'].')' : '');

		$message = $row['post_text'];
		$bbcode_uid = $row['bbcode_uid'];

		//
		// If the board has HTML off but the post has HTML
		// on then we process it, else leave it alone
		//
		if ( !$board_config['allow_html'] && $row['enable_html'] )
		{
			$message = preg_replace('#(<)([\/]?.*?)(>)#is', '&lt;\2&gt;', $message);
		}

		if ( $bbcode_uid != "" )
		{
			$message = ( $board_config['allow_bbcode'] ) ? bbencode_second_pass($message, $bbcode_uid) : preg_replace('/\:[0-9a-z\:]+\]/si', ']', $message);
		}

		$message = make_clickable($message);

		if ( count($orig_word) )
		{
			$post_subject = preg_replace($orig_word, $replacement_word, $post_subject);
			$topic_title = preg_replace($orig_word, $replacement_word, $topic_title);
			$message = preg_replace($orig_word, $replacement_word, $message);
		}

		if ( $board_config['allow_smilies'] && $row['enable_smilies'] )
		{
			$message = smilies_pass($message);
		}

		$message = str_replace("\n", '<br />', $message);

		$post_details[] = array('post_id'		=> $post_id,
										'poster_id'		=> $poster_id,
										'poster'			=> $poster,
										'post_date'		=> $post_date,
										'post_subject'	=> $post_subject,
										'topic_title'	=> $topic_title,
										'message'		=> $message,
										'forum_id'		=> $forum_id,
										'forum_name'	=> $forum_name
									);
	}

	return ( $return == 'single' && !empty($post_details[0]) ) ? $post_details[0] : $post_details;
}


// input :
// $report_data = string containing all the report reasons/actions as ids seperated by commas
// $code = 'reason' or 'action'
//
// output : string containing all the report reasons/actions as words seperated by commas
function create_report_data($report_data, $code)
{
	if ( $report_data == '' )
	{
		return '';
	}

	// get the report reasons/actions from the db
	$report_data_ids = array();
	$report_data_ids = get_reports_data($code);

	// check if we have more than 1 reason/action
	if ( strstr($report_data, ',') )
	{
		$report_data_ary = array();
		$report_data_ary = explode(',', $report_data);
	}
	else
	{
		$report_data_ary = array($report_data);
	}

	$report_data_words = '';
	foreach ( $report_data_ary as $row1 )
	{
		foreach ( $report_data_ids as $row2 )
		{
			if ( $row1 == $row2['data_id'] )
			{
				$report_data_words .= ( empty($report_data_words) ) ? $row2['data_name'] : ', ' . $row2['data_name'];
			}
		}
	}

	return $report_data_words;
}

// Remove report status from posts
// this has be to be called before deleting the report
function remove_post_report_status($report_ids)
{
	global $db;

	$report_ids = ( !is_array($report_ids) ) ? array($report_ids) : $report_ids;

	// reset the reported posts status
	$sql = "SELECT post_id
			FROM " . REPORTS_POSTS_TABLE . "
			WHERE report_id IN (" . implode(',', $report_ids) . ")";

	if ( !$db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain posts information', '', __LINE__, __FILE__, $sql);
	}

	$post_ids = array();
	while( $row = $db->sql_fetchrow($result) )
	{
		if ( !in_array($row['post_id'], $post_ids) )
		{
			$post_ids[] = $row['post_id'];
		}
	}

	if ( !empty($post_ids) )
	{
		$sql = "UPDATE " . POSTS_TABLE . "
			SET post_reported = 0
			WHERE post_id IN (" . implode(',', $post_ids) . ")";

		if ( !$db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Could not update post status', '', __LINE__, __FILE__, $sql);
		}
	}

	return;
}

// Delete reports
//
// input:
// $mode = 'user' (change the post status, delete the report)
// $mode = 'mod' (change the post status, delete the report, delete the report actions)
//
function delete_reports($report_ids, $mode = 'user')
{
	global $db;

	$report_ids = ( !is_array($report_ids) ) ? array($report_ids) : $report_ids;

	// this has to be done first
	remove_post_report_status($report_ids);

	// delete the selected reports
	$sql = "DELETE FROM " . REPORTS_POSTS_TABLE . "
		WHERE report_id IN (" . implode(',', $report_ids) . ")";

	if ( !$db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Could not delete reports', '', __LINE__, __FILE__, $sql);
	}

	if ( $mode == 'mod' )
	{
		// delete the selected actions too
		$sql = "DELETE FROM " . REPORTS_ACTIONS_TABLE . "
			WHERE report_id IN (" . implode(',', $report_ids) . ")";

		if ( !$db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Could not delete report actions', '', __LINE__, __FILE__, $sql);
		}
	}

	return;
}

// Delete actions
function delete_actions($report_ids)
{
	global $db;

	$report_ids = ( !is_array($report_ids) ) ? array($report_ids) : $report_ids;

	// delete the selected actions
	$sql = "DELETE FROM " . REPORTS_ACTIONS_TABLE . "
		WHERE report_id IN (" . implode(',', $report_ids) . ")";

	if ( !$db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, 'Could not delete report actions', '', __LINE__, __FILE__, $sql);
	}

	return;
}

// find which reports have their posts non-existent
function get_reports_with_no_posts()
{
	global $db;

/*
	$sql = "SELECT rp.post_id
		FROM " . REPORTS_POSTS_TABLE . ' rp, ' . POSTS_TABLE . " p
		WHERE rp.post_id = p.post_id";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query reports', '', __LINE__, __FILE__, $sql);
	}

	// create an array with all the common post_ids of the reports and posts table
	$common_post_ids = array();
	while( $row = $db->sql_fetchrow($result) )
	{
		$common_post_ids[] = $row['post_id'];
	}

	// get all the post_ids from the reports table
	$sql = "SELECT report_id, post_id
		FROM " . REPORTS_POSTS_TABLE ;

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query reports', '', __LINE__, __FILE__, $sql);
	}

	// find which reports exist in the reports table but do not exist in the posts table
	// these reports are the ones to be deleted
	$delete_ids = array();
	while ( $row = $db->sql_fetchrow($result) )
	{
		if ( !in_array($row['post_id'], $common_post_ids) )
		{
			$delete_ids[] = $row['report_id'];
		}
	}

*/

	// find which reports exist in the reports table but their posts do not exist in the posts table
	$sql = "SELECT DISTINCT rp.report_id
		FROM " . REPORTS_POSTS_TABLE . " rp
		LEFT JOIN " . POSTS_TABLE . " p ON rp.post_id = p.post_id
		WHERE p.post_id IS NULL";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query reports', '', __LINE__, __FILE__, $sql);
	}

	$delete_ids = array();
	while ( $row = $db->sql_fetchrow($result) )
	{
		$delete_ids[] = $row['report_id'];
	}

	return $delete_ids;
}


// find which actions have their reports non-existent
function get_actions_with_no_reports()
{
	global $db;

	// find which actions exist in the actions table but their reports do not exist in the reports table
	$sql = "SELECT DISTINCT ra.report_id
		FROM " . REPORTS_ACTIONS_TABLE . " ra
		LEFT JOIN " . REPORTS_POSTS_TABLE . " rp ON ra.report_id = rp.report_id
		WHERE rp.report_id IS NULL";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query actions', '', __LINE__, __FILE__, $sql);
	}

	$delete_ids = array();
	while ( $row = $db->sql_fetchrow($result) )
	{
		$delete_ids[] = $row['report_id'];
	}

	return $delete_ids;
}

?>
