<?php

/***************************************************************************
 *                           admin_report_posts.php
 *                           ----------------------
 *     begin                : Mon May 9 2005
 *     copyright            : (C) 2001 The phpBB Group
 *     email                : support@phpbb.com
 *
 *     $Id: admin_report_posts.php,v 2.1.5.0 2005/10/28 18:38:17 chatasos Exp $
 *
 ****************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define ('IN_PHPBB', true);

if ( !empty($setmodules) )
{
	$filename = basename(__FILE__);
	$module['Report Posts']['Configuration'] = "$filename?mode=config";	// define in lang_admin.php
	$module['Report Posts']['Reasons/Actions'] = "$filename?mode=data";
	return;
}

//
// Let's set the root dir for phpBB
//
$no_page_header = true;
$phpbb_root_path = "./../";
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);
include($phpbb_root_path . 'includes/functions_report_global.'.$phpEx);
include($phpbb_root_path . 'includes/functions_report.'.$phpEx);


//
// Language File
//
include($phpbb_root_path.'language/lang_'.$board_config['default_lang'].'/lang_report_posts.'.$phpEx);


// define some constants



//
// Define initial vars
//



// find the mode we are in
if ( isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode'])  )
{
	$mode = ( isset($HTTP_POST_VARS['mode']) ) ? htmlspecialchars($HTTP_POST_VARS['mode']) : htmlspecialchars($HTTP_GET_VARS['mode']);
}
else
{
	$mode = '';
}


// find the param when we are in 'data' mode
if ( $mode == 'data' && ( isset($HTTP_GET_VARS['param']) || isset($HTTP_POST_VARS['param']) ) )
{
	$param = ( isset($HTTP_POST_VARS['param']) ) ? htmlspecialchars($HTTP_POST_VARS['param']) : htmlspecialchars($HTTP_GET_VARS['param']);
}
else
{
	$param = '';
}

if ( isset($HTTP_POST_VARS['cancel']) && $mode != '' )
{
	redirect('admin/' . append_sid("admin_report_posts.$phpEx?mode=$mode", true));
}


//
// Main code starts from here
//

if ( $mode == 'config' )
{
		//
		// Pull all config data
		//
		$sql = "SELECT * FROM " . REPORTS_CONFIG_TABLE;

		if (!$result = $db->sql_query($sql))
		{
			message_die(CRITICAL_ERROR, "Could not query config information", "", __LINE__, __FILE__, $sql);
		}

		while ( $row = $db->sql_fetchrow($result) )
		{
			$config_name = $row['config_name'];
			$config_value = $row['config_value'];

			if ( isset($HTTP_POST_VARS['submit']) && (( $config_name == 'user_panels' ) || ( $config_name == 'mod_panels' )) )
			{

				// [user_panel_enabled] => Array ( [0] => report_info [1] => post_info [2] => user_reports_info )
				// [user_panel_active] => report_info

				$mode = ( $config_name == 'user_panels' ) ? 'user' : 'mod';

				// get the admin's selections
				// no need for htmlspecialchars/intval here, because these actually are our own "hidden" values, not user's
				if ( isset($HTTP_POST_VARS[$mode.'_panel_enabled']) && is_array($HTTP_POST_VARS[$mode.'_panel_enabled']) )
				{
					// maybe process in loop here
					$panel_enabled_ary = $HTTP_POST_VARS[$mode.'_panel_enabled'];
				}
				else
				{
					$panel_enabled_ary = array();
				}

				if ( isset($HTTP_POST_VARS[$mode.'_panel_active']) )
				{
					$panel_active = $HTTP_POST_VARS[$mode.'_panel_active'];
				}
				else
				{
					$panel_active = '';
				}

				$new[$config_name] = create_panel_config($mode, $panel_enabled_ary, $panel_active);

				//echo "<hr />*" . $new[$config_name] . "*";
				//exit;

			}
			else
			{
				$default_config[$config_name] = isset($HTTP_POST_VARS['submit']) ? str_replace("'", "\'", $config_value) : $config_value;
				$new[$config_name] = ( isset($HTTP_POST_VARS[$config_name]) ) ? $HTTP_POST_VARS[$config_name] : $default_config[$config_name];
			}

			if ( isset($HTTP_POST_VARS['submit']) )
			{
				$sql = "UPDATE " . REPORTS_CONFIG_TABLE . "
				SET config_value = '" . str_replace("\'", "''", $new[$config_name]) . "'
					WHERE config_name = '$config_name'";

				if ( !$db->sql_query($sql) )
				{
					message_die(GENERAL_ERROR, "Failed to update configuration for $config_name", "", __LINE__, __FILE__, $sql);
				}
			}
		}

		if ( isset($HTTP_POST_VARS['submit']) )
		{
			$message = $lang['Config_updated'] . "<br /><br />" . sprintf($lang['Click_return_admin'], '<a href="' . append_sid("admin_report_posts.$phpEx?mode=config") . '">', '</a>');
			message_die(GENERAL_MESSAGE, $message);
		}


		$email_notification_yes = ( $new['email_notification'] ) ? 'checked="checked"' : '';
		$email_notification_no = ( !$new['email_notification'] ) ? 'checked="checked"' : '';

		$mods_delete_yes = ( $new['allow_mods_delete'] ) ? 'checked="checked"' : '';
		$mods_delete_no = ( !$new['allow_mods_delete'] ) ? 'checked="checked"' : '';

		$mods_pm_yes = ( $new['allow_mods_pm'] ) ? 'checked="checked"' : '';
		$mods_pm_no = ( !$new['allow_mods_pm'] ) ? 'checked="checked"' : '';

		$mods_email_yes = ( $new['allow_mods_email'] ) ? 'checked="checked"' : '';
		$mods_email_no = ( !$new['allow_mods_email'] ) ? 'checked="checked"' : '';

		$action_desc_yes = ( $new['show_action_desc'] ) ? 'checked="checked"' : '';
		$action_desc_no = ( !$new['show_action_desc'] ) ? 'checked="checked"' : '';

		$default_reports_status_all = ( $new['default_reports_status'] == 0 ) ? 'checked="checked"' : '';
		$default_reports_status_new = ( $new['default_reports_status'] == 1 ) ? 'checked="checked"' : '';
		$default_reports_status_close = ( $new['default_reports_status'] == 2 ) ? 'checked="checked"' : '';
		$default_reports_status_reopen = ( $new['default_reports_status'] == 3 ) ? 'checked="checked"' : '';

		$multiple_reports_yes = ( $new['allow_multiple_reports'] ) ? 'checked="checked"' : '';
		$multiple_reports_no = ( !$new['allow_multiple_reports'] ) ? 'checked="checked"' : '';

		$users_own_yes = ( $new['allow_users_own'] ) ? 'checked="checked"' : '';
		$users_own_no = ( !$new['allow_users_own'] ) ? 'checked="checked"' : '';

		$users_edit_yes = ( $new['allow_users_edit'] ) ? 'checked="checked"' : '';
		$users_edit_no = ( !$new['allow_users_edit'] ) ? 'checked="checked"' : '';

		$users_delete_yes = ( $new['allow_users_delete'] ) ? 'checked="checked"' : ( ( $users_edit_no != '' ) ? 'disabled="disabled"' : '');
		$users_delete_no = ( !$new['allow_users_delete'] ) ? 'checked="checked"' : '';

		$reason_desc_yes = ( $new['show_reason_desc'] ) ? 'checked="checked"' : '';
		$reason_desc_no = ( !$new['show_reason_desc'] ) ? 'checked="checked"' : '';


		$user_panels = array();
		$user_panels = get_panels($new['user_panels']);

		// maybe send all as hidden
		$user_panel = array();
		for ( $i = 0; $i < count($user_panels); $i++ )
		{
			$user_panel[$user_panels[$i]['panel_name'].'_enabled'] = ( $user_panels[$i]['panel_enabled'] ) ? 'checked="checked"' : '';
			$user_panel[$user_panels[$i]['panel_name'].'_active'] = ( $user_panels[$i]['panel_enabled'] ) ? (( $user_panels[$i]['panel_active'] ) ? 'checked="checked"' : '') : 'disabled="disabled"';
			$user_panel[$user_panels[$i]['panel_name'].'_value'] = $user_panels[$i]['panel_name'];
		}

		$mod_panels = array();
		$mod_panels = get_panels($new['mod_panels']);

		// maybe send all as hidden
		$mod_panel = array();
		for ( $i = 0; $i < count($mod_panels); $i++ )
		{
			$mod_panel[$mod_panels[$i]['panel_name'].'_enabled'] = ( $mod_panels[$i]['panel_enabled'] ) ? "checked=\"checked\"" : "";
			$mod_panel[$mod_panels[$i]['panel_name'].'_active'] = ( $mod_panels[$i]['panel_enabled'] ) ? (( $mod_panels[$i]['panel_active'] ) ? "checked=\"checked\"" : "") : 'disabled="disabled"';
			$mod_panel[$mod_panels[$i]['panel_name'].'_value'] = $mod_panels[$i]['panel_name'];
		}

		// create the page
		$page_title = $lang['Page_title'];
		include('./page_header_admin.'.$phpEx);

		$template->set_filenames(array(
	   	 "body" => "admin/report_config_body.tpl")
		);

		// create the output of page
		$template->assign_vars(array(
			'L_REPORT_POSTS'	=> $lang['Report_posts'],

			'L_CONFIGURATION_EXPLAIN'	=> $lang['Configuration_explain'],

			'L_YES'		=> $lang['Yes'],
			'L_NO'		=> $lang['No'],
			'L_SUBMIT'	=> $lang['Submit'],
			'L_RESET'	=> $lang['Reset'],

			// mods
			'S_EMAIL_NOTIFICATION_YES'	=> $email_notification_yes,
			'S_EMAIL_NOTIFICATION_NO'	=> $email_notification_no,

			'S_MODS_DELETE_YES'	=> $mods_delete_yes,
			'S_MODS_DELETE_NO'	=> $mods_delete_no,

			'S_MODS_PM_YES'	=> $mods_pm_yes,
			'S_MODS_PM_NO'		=> $mods_pm_no,

			'S_MODS_EMAIL_YES'	=> $mods_email_yes,
			'S_MODS_EMAIL_NO'		=> $mods_email_no,

			'S_ACTION_DESC_YES'	=> $action_desc_yes,
			'S_ACTION_DESC_NO'	=> $action_desc_no,

			'S_REPORTS_STATUS_ALL'		=>	$default_reports_status_all,
			'S_REPORTS_STATUS_NEW'		=>	$default_reports_status_new,
			'S_REPORTS_STATUS_CLOSE'	=>	$default_reports_status_close,
			'S_REPORTS_STATUS_REOPEN'	=>	$default_reports_status_reopen,

			// users
			'S_MULTIPLE_REPORTS_YES'	=> $multiple_reports_yes,
			'S_MULTIPLE_REPORTS_NO'		=> $multiple_reports_no,

			'S_USERS_OWN_YES'		=> $users_own_yes,
			'S_USERS_OWN_NO'		=> $users_own_no,

			'S_USERS_EDIT_YES'	=> $users_edit_yes,
			'S_USERS_EDIT_NO'		=> $users_edit_no,

			'S_USERS_DELETE_YES'	=> $users_delete_yes,
			'S_USERS_DELETE_NO'	=> $users_delete_no,

			'S_REASON_DESC_YES'	=> $reason_desc_yes,
			'S_REASON_DESC_NO'	=> $reason_desc_no,

			'REPORTS_PER_PAGE'	=> $new['reports_per_page'],
			'ACTIONS_PER_REPORT'	=> $new['actions_per_report'],
			'FLOOD_INTERVAL'		=> $new['users_flood_interval'],

			// mod panels
			'MP_REPORT_VALUE'			=> $mod_panel['report_info_value'],
			'MP_POST_VALUE'			=> $mod_panel['post_info_value'],
			'MP_POSTER_VALUE'			=> $mod_panel['poster_info_value'],
			'MP_ACTION_VALUE'			=> $mod_panel['action_info_value'],

			'S_MP_REPORT_ENABLED'	=> $mod_panel['report_info_enabled'],
			'S_MP_POST_ENABLED'		=> $mod_panel['post_info_enabled'],
			'S_MP_POSTER_ENABLED'	=> $mod_panel['poster_info_enabled'],
			'S_MP_ACTION_ENABLED'	=> $mod_panel['action_info_enabled'],

			'S_MP_REPORT_ACTIVE'	=> $mod_panel['report_info_active'],
			'S_MP_POST_ACTIVE'	=> $mod_panel['post_info_active'],
			'S_MP_POSTER_ACTIVE'	=> $mod_panel['poster_info_active'],
			'S_MP_ACTION_ACTIVE'	=> $mod_panel['action_info_active'],

			// user panels
			'UP_REPORT_VALUE'			=> $user_panel['report_info_value'],
			'UP_POST_VALUE'			=> $user_panel['post_info_value'],
			'UP_USER_REPORTS_VALUE'	=> $user_panel['user_reports_info_value'],

			'S_UP_REPORT_ENABLED'			=> $user_panel['report_info_enabled'],
			'S_UP_POST_ENABLED'				=> $user_panel['post_info_enabled'],
			'S_UP_USER_REPORTS_ENABLED'	=> $user_panel['user_reports_info_enabled'],

			'S_UP_REPORT_ACTIVE'			=> $user_panel['report_info_active'],
			'S_UP_POST_ACTIVE'			=> $user_panel['post_info_active'],
			'S_UP_USER_REPORTS_ACTIVE'	=> $user_panel['user_reports_info_active'],

			// colors
			'COLOR_STATUS_OPEN'		=> $new['color_status_open'],
			'COLOR_STATUS_CLOSED'	=> $new['color_status_closed'],
			'COLOR_STATUS_REOPENED'	=> $new['color_status_reopened'],

			'REPORT_POSTS_VERSION'	=> REPORT_POSTS_VERSION,

			'S_HIDDEN_FIELDS'				=> $s_hidden_fields,
			'S_REBUILD_SEARCH_ACTION'	=> append_sid("admin_report_posts.$phpEx?mode=config"))
		);

		$template->pparse('body');

		include('./page_footer_admin.'.$phpEx);

		exit;
}
else
{
	// check for the various parameters in the data page
	switch ( $param )
	{
		case '':
			// check if we should update the comments field
			if ( isset($HTTP_POST_VARS['update_reason_comments']) || isset($HTTP_POST_VARS['update_action_comments']) )
			{
				$data_code = ( isset($HTTP_POST_VARS['update_reason_comments']) ) ? 'reason' : 'action';

				// reset all
				$sql = "UPDATE " . REPORTS_DATA_TABLE . "
				SET data_comments = 0
				WHERE data_code = " . ( ( $data_code == 'reason' ) ? REPORT_CODE_REASON : REPORT_CODE_ACTION );

				if ( !$db->sql_query($sql) )
				{
					message_die(GENERAL_ERROR, 'Could not update reports data', '', __LINE__, __FILE__, $sql);
				}

				// update only the checked ones
				if ( isset($HTTP_POST_VARS[$data_code.'_comments']) && !empty($HTTP_POST_VARS[$data_code.'_comments'])	)
				{
					$data_ids = array();
					foreach ($HTTP_POST_VARS[$data_code.'_comments'] as $row)
					{
						$data_ids[] = intval($row);
					}

					$sql = "UPDATE " . REPORTS_DATA_TABLE . "
					SET data_comments = 1
					WHERE data_code = " . ( ( $data_code == 'reason' ) ? REPORT_CODE_REASON : REPORT_CODE_ACTION ) . "
						AND data_id IN (" . implode(',', $data_ids). ")";

					if ( !$db->sql_query($sql) )
					{
						message_die(GENERAL_ERROR, 'Could not update reports data', '', __LINE__, __FILE__, $sql);
					}
				}

				$template->assign_vars(array(
					'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("admin_report_posts.$phpEx?mode=data") . '" />')
				);

				$message = ( ( $data_code == 'reason' ) ? $lang['Report_reasons_updated'] : $lang['Report_actions_updated'] ) . '<br /><br />' . sprintf($lang['Click_return_admin'], '<a href="' . append_sid("admin_report_posts.$phpEx?mode=data") . '">', '</a>');
				message_die(GENERAL_MESSAGE, $message);

			}	// check if we should add a reason/action
			elseif ( isset($HTTP_POST_VARS['add_reason']) || isset($HTTP_POST_VARS['add_action']) || isset($HTTP_POST_VARS['submit_data']) )
			{
				if ( isset($HTTP_POST_VARS['submit_data']) )
				{
					$data_code = ( isset($HTTP_POST_VARS['data_code']) ) ? intval($HTTP_POST_VARS['data_code']) : '';

					if ( $data_code != '' )
					{
						$sql = "INSERT INTO " . REPORTS_DATA_TABLE . "
						SET
							data_name = '" . str_replace("\'", "''", $HTTP_POST_VARS['data_name']) . "',
							data_desc = '" . str_replace("\'", "''", $HTTP_POST_VARS['data_desc']) . "',
							data_comments = " . ( ( $HTTP_POST_VARS['data_comments'] ) ? 1 : 0 ) . ",
							data_order = " . get_next_order( ( $data_code == REPORT_CODE_REASON ) ? 'reason' : 'action') . ",
							data_code = $data_code";

						if ( !$db->sql_query($sql) )
						{
							message_die(GENERAL_ERROR, 'Could not insert reports data', '', __LINE__, __FILE__, $sql);
						}

						if ( $data_code == REPORT_CODE_REASON )
						{
							renumber_order('reason');
						}
						else
						{
							renumber_order('action');
						}


						$template->assign_vars(array(
							'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("admin_report_posts.$phpEx?mode=data") . '" />')
						);

						$message = ( ( $data_code == REPORT_CODE_REASON ) ? $lang['Report_reasons_updated'] : $lang['Report_actions_updated'] ) . '<br /><br />' . sprintf($lang['Click_return_admin'], '<a href="' . append_sid("admin_report_posts.$phpEx?mode=data") . '">', '</a>');
						message_die(GENERAL_MESSAGE, $message);
					}
				}
				else
				{

					$page_title = $lang['Page_title'];
					include('./page_header_admin.'.$phpEx);

					$template->set_filenames(array(
						"body" => "admin/report_data_body.tpl")
					);

					$template->assign_block_vars("edit_data", array(
						)
					);

					$data_code = ( isset($HTTP_POST_VARS['add_reason']) ) ? REPORT_CODE_REASON : REPORT_CODE_ACTION;
					$s_hidden_fields .= '<input type="hidden" name="data_code" value="' . $data_code . '">';

					// create the output of page
					$template->assign_vars(array(
						'L_EDIT_DATA'		=> ( isset($HTTP_POST_VARS['add_reason']) ) ? $lang['Add_reason'] : $lang['Add_action'],

						'S_HIDDEN_FIELDS'	=> $s_hidden_fields,
						'S_REPORT_ACTION'	=> append_sid("admin_report_posts.$phpEx?mode=data")
						)
					);

					$template->pparse('body');
				}
				$show_data = false;
			}
			else
			{
				$show_data = true;
			}

			break;

		case 'edit':

			$data_id = ( !empty($HTTP_POST_VARS['data_id']) ) ? $HTTP_POST_VARS['data_id'] : $HTTP_GET_VARS['data_id'];
			$data_id = intval($data_id);

			$data_code = ( !empty($HTTP_POST_VARS['data_code']) ) ? intval($HTTP_POST_VARS['data_code']) : '';

			if ( isset($HTTP_POST_VARS['submit_data']) && $data_code != '' )
			{

				$sql = "UPDATE " . REPORTS_DATA_TABLE . "
				SET
					data_name = '" . str_replace("\'", "''", $HTTP_POST_VARS['data_name']) . "',
					data_desc = '" . str_replace("\'", "''", $HTTP_POST_VARS['data_desc']) . "',
					data_comments = " . ( ($HTTP_POST_VARS['data_comments']) ? 1 : 0 ) . "
				WHERE data_id = $data_id";

				if ( !$db->sql_query($sql) )
				{
					message_die(GENERAL_ERROR, 'Could not update reports data', '', __LINE__, __FILE__, $sql);
				}

				$template->assign_vars(array(
					'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("admin_report_posts.$phpEx?mode=data") . '" />')
				);

				$message = ( ( $data_code == REPORT_CODE_REASON ) ? $lang['Report_reasons_updated'] : $lang['Report_actions_updated'] ) . '<br /><br />' . sprintf($lang['Click_return_admin'], '<a href="' . append_sid("admin_report_posts.$phpEx?mode=data") . '">', '</a>');
				message_die(GENERAL_MESSAGE, $message);
			}
			else
			{

				$page_title = $lang['Page_title'];
				include('./page_header_admin.'.$phpEx);

				$template->set_filenames(array(
				    "body" => "admin/report_data_body.tpl")
				);

				$data_details = array();
				$data_details = get_reports_data('', $data_id);

				//print_r($data_details);

				// maybe add a warning if this data is being used
				$template->assign_block_vars("edit_data", array(
					'NAME'		=> $data_details['data_name'],
					'DESC'		=> $data_details['data_desc'],
					'CHECKED'	=> ( $data_details['data_comments'] ) ? 'checked="checked"' : ''
					)
				);

				$s_hidden_fields .= '<input type="hidden" name="data_id" value="' . $data_details['data_id'] . '">';
				$s_hidden_fields .= '<input type="hidden" name="data_code" value="' . $data_details['data_code'] . '">';

				$template->assign_vars(array(
					'L_EDIT_DATA'		=> ( $data_details['data_code'] == REPORT_CODE_REASON) ? 'Edit reason' : 'Edit action',

					'S_HIDDEN_FIELDS'	=> $s_hidden_fields,
					'S_REPORT_ACTION'	=> append_sid("admin_report_posts.$phpEx?mode=data&amp;param=edit")
					)
				);

				$template->pparse('body');
			}

			$show_data = false;
			break;

		case 'delete':

			$data_id = ( !empty($HTTP_POST_VARS['data_id']) ) ? $HTTP_POST_VARS['data_id'] : $HTTP_GET_VARS['data_id'];
			$data_id = intval($data_id);

			$data_details = array();
			$data_details = get_reports_data('', $data_id);

			// maybe add a warning if this data is being used

			$sql = "DELETE FROM " . REPORTS_DATA_TABLE . "
				WHERE data_id = $data_id";

			if ( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, 'Could not delete reports data', '', __LINE__, __FILE__, $sql);
			}

			if ( $data_details['data_code'] == REPORT_CODE_REASON )
			{
				renumber_order('reason');
			}
			else
			{
				renumber_order('action');
			}

			$template->assign_vars(array(
				'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("admin_report_posts.$phpEx?mode=data") . '" />')
			);

			$message = (( $data_details['data_code'] == REPORT_CODE_REASON ) ? $lang['Report_reasons_updated'] : $lang['Report_actions_updated'] ) . '<br /><br />' . sprintf($lang['Click_return_admin'], '<a href="' . append_sid("admin_report_posts.$phpEx?mode=data") . '">', '</a>');
			message_die(GENERAL_MESSAGE, $message);

			break;

		case 'data_order':

			$move = intval($HTTP_GET_VARS['move']);
			$data_id = intval($HTTP_GET_VARS['data_id']);

			$sql = "UPDATE " . REPORTS_DATA_TABLE . "
				SET data_order = data_order + $move
				WHERE data_id = $data_id";

			if ( !$result = $db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, "Couldn't change reports data order", "", __LINE__, __FILE__, $sql);
			}

			// get the data_code from somewhere (POST/GET) in order to avoid updating both
			renumber_order('reason');
			renumber_order('action');

			$show_data = true;
			break;

		default:
			message_die(GENERAL_MESSAGE, $lang['No_mode']);
			break;
	}		// switch ( $param )


	// check if we need to display all the data
	if ( $show_data == false )
	{
		include('./page_footer_admin.'.$phpEx);
		exit;
	}

}


// display all the data

$page_title = $lang['Page_title'];
include('./page_header_admin.'.$phpEx);

$template->set_filenames(array(
    "body" => "admin/report_data_body.tpl")
);

show_reports_data('reason');

show_reports_data('action');

$template->assign_vars(array(
	'L_REPORT_POSTS'	=> $lang['Report_posts'],
	'L_DATA_EXPLAIN'	=> $lang['Data_explain'],

	'REPORT_POSTS_VERSION'	=> REPORT_POSTS_VERSION,

	'S_HIDDEN_FIELDS'	=> $s_hidden_fields,
	'S_REPORT_ACTION'	=> append_sid("admin_report_posts.$phpEx?mode=data")
	)
);

$template->pparse('body');

//
// Page Footer
//
include('./page_footer_admin.'.$phpEx);

?>
